package com.small_it_office.flatserve.core;

import java.io.IOException;
import java.util.Locale;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.small_it_office.flatserve.core.config.ApplicationInitializer;
import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.config.InitializationException;
import com.small_it_office.flatserve.core.config.internal.DefaultApplicationInitializer;
import com.small_it_office.flatserve.core.process.internal.HttpServiceProcessor;
import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import com.small_it_office.shared.meslog.message.Message;

/**
 * HTTPNCAg̗B̃Gg|CgłT[ubgłB
 * ݒ̏ƃNGXg̎t݂̂sANGXgt̏͑S{@link HttpServiceProcessor}ɈϏĂ܂B
 */
public class FlatServe extends HttpServlet {

	/**
	 * init-paramɋLqApplicationInitializerNXparam-nameB
	 */
	private static final String PARAM_NAME_INIT_CLASS_NAME = "init-class-name";

	/**
	 * HTTPServiceProcessor̃CX^XB
	 */
	private HttpServiceProcessor processor;

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * AvP[VNX̃CX^X擾A
	 * ĂяoConfig𐶐܂B
	 * ܂AOG[̃bZ[W܂B
	 * @see javax.servlet.GenericServlet#init()
	 */
	@Override
	public void init() {
		Message.load("flatserve-messages");

		logger.debug("FS-LOGD001");

		ApplicationInitializer initializer = createInitializer();

		Config config = createConfig(initializer);

		logger.debug("FS-LOGD002", config);

		if (!Locale.getDefault().equals(config.getLocale())) {
			Message.clear("flatserve-messages");
			Message.load("flatserve-messages", config.getLocale());
		}

		processor = new HttpServiceProcessor(config, getServletConfig());
	}

	/**
	 * AvP[VNX̃CX^X𐶐܂B
	 * @return AvP[VNX̃CX^X
	 */
	ApplicationInitializer createInitializer() {
		String initClassName = getServletConfig().getInitParameter(PARAM_NAME_INIT_CLASS_NAME);
		if (initClassName == null) {
			logger.debug("FS-LOGD003");
			return new DefaultApplicationInitializer();
		}
		Class<?> initClass;
		try {
			initClass = Class.forName(initClassName);
		} catch (ClassNotFoundException e) {
			throw new InitializationException(Message.get("FS-ERR002", initClassName), e);
		}

		if (!ApplicationInitializer.class.isAssignableFrom(initClass)) {
			throw new InitializationException(Message.get("FS-ERR003", initClassName));
		}

		ApplicationInitializer initializer;
		try {
			initializer = (ApplicationInitializer)initClass.newInstance();
		} catch (Exception e) {
			throw new InitializationException(Message.get("FS-ERR004", initClassName), e);
		}
		return initializer;
	}

	/**
	 * AvP[VNXsConfig擾܂B
	 * @param initializer AvP[VNX̃CX^X
	 * @return ConfigIuWFNg
	 * @throws InitializationException AvP[VNXOthrowA܂null߂lŕԂꍇB
	 */
	Config createConfig(ApplicationInitializer initializer) {
		String initializerClassName = initializer.getClass().getName();

		logger.info("FS-LOGI001", initializerClassName);

		Config config;
		try {
			config = initializer.init(getServletConfig());
		} catch (Throwable e) {
			throw new InitializationException(Message.get("FS-ERR005", initializer.getClass().getName()), e);
		}

		if (config == null) {
			throw new InitializationException(Message.get("FS-ERR006", initializer.getClass().getName()));
		}

		logger.info("FS-LOGI002", initializerClassName);

		return config;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException,
	        IOException {
		logger.info("FS-LOGI003", request.getRequestURI(), "POST");
		doProcess(request, response);
		logger.info("FS-LOGI004", request.getRequestURI(), "POST");
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		logger.info("FS-LOGI003", request.getRequestURI(), "GET");
		doProcess(request, response);
		logger.info("FS-LOGI004", request.getRequestURI(), "GET");
	}

	/**
	 * HttpServiceProcessorɏϏ܂B
	 * @param request NGXgIuWFNg
	 * @param response X|XIuWFNg
	 * @throws IOException o͗O
	 */
	private void doProcess(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RequestContext.create(request, response, getServletConfig());
		try {
			processor.process();
		} finally {
			RequestContext.clear();
		}
	}

}
