package com.small_it_office.flatserve.core.plugin.core.internal;

import javax.servlet.ServletConfig;

import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.plugin.internal.PluginImplementation;
import com.small_it_office.flatserve.core.request.internal.RequestParameterMapper;
import com.small_it_office.flatserve.core.request.internal.RequestParameterMapperImpl;
import com.small_it_office.flatserve.core.request.internal.RequestParameterReader;
import com.small_it_office.flatserve.core.request.internal.RequestParameterReaderImpl;
import com.small_it_office.flatserve.core.response.internal.ResponseSender;
import com.small_it_office.flatserve.core.response.internal.ResponseSenderImpl;
import com.small_it_office.flatserve.core.service.internal.HttpServiceExecutor;
import com.small_it_office.flatserve.core.service.internal.HttpServiceExecutorImpl;
import com.small_it_office.flatserve.core.service.internal.HttpServiceFactory;
import com.small_it_office.flatserve.core.service.internal.HttpServiceFactoryImpl;

/**
 * RAW[̎\NXłB
 * ̃NX́APluginC^[tF[XAvOC̈Ƃē삵܂B
 */
public class CoreModule implements PluginImplementation {

	/**
	 * {@inheritDoc}
	 */
	public HttpServiceExecutor getHttpServiceExecutor() {
		return new HttpServiceExecutorImpl();
	}

	/**
	 * {@inheritDoc}
	 */
	public HttpServiceFactory getHttpServiceFactory() {
		return new HttpServiceFactoryImpl();
	}

	/**
	 * {@inheritDoc}
	 */
	public RequestParameterMapper getRequestParameterMapper() {
		return new RequestParameterMapperImpl();
	}

	/**
	 * {@inheritDoc}
	 */
	public RequestParameterReader getRequestParameterReader() {
		return new RequestParameterReaderImpl();
	}

	/**
	 * {@inheritDoc}
	 */
	public ResponseSender getResponseSender() {
		return new ResponseSenderImpl();
	}

	/**
	 * {@inheritDoc}
	 */
	public void init(Config config, ServletConfig servletConfig) {

	}

}
