package com.small_it_office.flatserve.core.plugin.internal;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.servlet.ServletConfig;

import com.small_it_office.flatserve.core.InfrastructureException;
import com.small_it_office.flatserve.core.UnexpectedException;
import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.request.internal.RequestParameterMapper;
import com.small_it_office.flatserve.core.request.internal.RequestParameterReader;
import com.small_it_office.flatserve.core.response.internal.ResponseSender;
import com.small_it_office.flatserve.core.service.internal.HttpServiceExecutor;
import com.small_it_office.flatserve.core.service.internal.HttpServiceFactory;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;

/**
 * vOCǂݍ݁AK؂ȃCX^XێNXłB
 */
public class PluginLoader {

	/**
	 * vOCNX`vpeB̃L[B
	 */
	private static final String KEY_PLUGIN_CLASS = "plugin.class";

	/**
	 * vOC̎NX`vpeB̃L[B
	 */
	private static final String KEY_PLUGIN_IMPLEMENTATION_CLASS = "plugin.implementation_class";

	/**
	 * vOCC^[tF[XƂɎIuWFNgێMapB
	 */
	private Map<Class<? extends PluginPart>, PluginPart> pluginParts = new HashMap<Class<? extends PluginPart>, PluginPart>();

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * ݒIuWFNgB
	 */
	private Config config;

	/**
	 * ServletConfigIuWFNgB
	 */
	private ServletConfig servletConfig;

	/**
	 * RXgN^B
	 * @param config ݒ
	 * @param servletConfig ServletConfigIuWFNgB
	 */
	public PluginLoader(Config config, ServletConfig servletConfig) {
		this.config = config;
		this.servletConfig = servletConfig;
		init();
	}

	/**
	 * ̖Õt@CvOC̏擾鏉łB
	 */
	private void init() {

		List<String> pluginDefs = loadPluginProperties();

		List<PluginImplementation> pluginImplementations = createPluginImplementationInstances(pluginDefs);

		List<RequestParameterReader> readers = new ArrayList<RequestParameterReader>();
		List<RequestParameterMapper> mappers = new ArrayList<RequestParameterMapper>();
		List<HttpServiceFactory> factories = new ArrayList<HttpServiceFactory>();
		List<HttpServiceExecutor> executors = new ArrayList<HttpServiceExecutor>();
		List<ResponseSender> senders = new ArrayList<ResponseSender>();
		for (PluginImplementation p : pluginImplementations) {
			p.init(config, servletConfig);
			readers.add(p.getRequestParameterReader());
			mappers.add(p.getRequestParameterMapper());
			factories.add(p.getHttpServiceFactory());
			executors.add(p.getHttpServiceExecutor());
			senders.add(p.getResponseSender());
		}

		Comparator<PluginPart> comparator = pluginPriorityComparator();
		Collections.sort(readers, comparator);
		Collections.sort(mappers, comparator);
		Collections.sort(factories, comparator);
		Collections.sort(executors, comparator);
		Collections.sort(senders, comparator);

		setUpPluginInstance(RequestParameterReader.class, readers);
		setUpPluginInstance(RequestParameterMapper.class, mappers);
		setUpPluginInstance(HttpServiceFactory.class, factories);
		setUpPluginInstance(HttpServiceExecutor.class, executors);
		setUpPluginInstance(ResponseSender.class, senders);
	}

	/**
	 * vOC`̃vpeBt@Cǂݍ݁A`ꂽNX̃Xg𐶐܂B
	 * @return vpeBt@CŒ`ꂽvOCNX̃Xg
	 */
	private List<String> loadPluginProperties() {
		ClassLoader loader = Thread.currentThread().getContextClassLoader();
		Enumeration<URL> resources;
		try {
			resources = loader.getResources("META-INF/flatserveplugin.properties");
		} catch (IOException e) {
			throw new InfrastructureException(e);
		}

		List<String> plugins = new ArrayList<String>();
		while (resources.hasMoreElements()) {
			URL url = resources.nextElement();
			Properties props = new Properties();
			try {
				props.load(url.openStream());
			} catch (IOException e) {
				throw new InfrastructureException(e);
			}
			String pluginImplementation = props.getProperty(KEY_PLUGIN_IMPLEMENTATION_CLASS);
			String plugin = props.getProperty(KEY_PLUGIN_CLASS);
			if (config.isPluginAutoDetect() || config.isAvailablePlugin(plugin)) {
				plugins.add(pluginImplementation);
			}
		}

		return plugins;
	}

	/**
	 * pvOCNX̃CX^X𐶐܂B
	 * @param pluginImplClasses vOCNX̃Xg
	 * @return vOCNX̃CX^X̃Xg
	 */
	private List<PluginImplementation> createPluginImplementationInstances(List<String> pluginImplClasses) {
		List<PluginImplementation> pluginImplementations = new ArrayList<PluginImplementation>();
		for (String pluginImplClass : pluginImplClasses) {
			Class<?> clazz;
			logger.debug("FS-LOGD038", pluginImplClass);
			try {
				clazz = Class.forName(pluginImplClass);
			} catch (ClassNotFoundException e) {
				throw new UnexpectedException(e);
			}
			Object instance;
			try {
				instance = clazz.newInstance();
			} catch (Exception e) {
				throw new UnexpectedException(e);
			}
			pluginImplementations.add(PluginImplementation.class.cast(instance));
		}
		return pluginImplementations;
	}

	/**
	 * vOC̎DxɃ\[g邽߂Comparator𐶐B
	 * @return Comparator̃CX^X
	 */
	private Comparator<PluginPart> pluginPriorityComparator() {
		Comparator<PluginPart> comparator = new Comparator<PluginPart>() {

			public int compare(PluginPart p1, PluginPart p2) {
				if (p1 == null && p2 == null) {
					return 0;
				} else if (p1 == null) {
					return 1;
				} else if (p2 == null) {
					return -1;
				}
				return p1.priority() - p2.priority();
			}
		};
		return comparator;
	}

	/**
	 * vOCiIuWFNg̃ZbgAbvs܂B
	 * D揇ʂɉăvOCilXgAs܂B
	 * D揇ʂႭApȂIuWFNg͏܂B
	 * @param <T> vOCC^[tF[X̌^
	 * @param pluginInterface CX^X𐶐EێΏۂ̃vOCC^[tF[X
	 * @param pluginPartList D揇Ƀ\[gꂽAvOCĩCX^X̃Xg
	 */
	private <T extends PluginPart> void setUpPluginInstance(Class<T> pluginInterface, List<T> pluginPartList) {
		logger.debug("FS-LOGD040", pluginInterface.getSimpleName(), pluginPartList.get(0).getClass().getName());
		for (int i = 0; i < pluginPartList.size(); i++) {
			T part = pluginPartList.get(i);
			if (part.nest()) {
				logger.debug("FS-LOGD039", part.getClass().getName(), pluginPartList.get(i + 1).getClass().getName());
				part.setNestedObject(pluginPartList.get(i + 1));
				part.init(config, servletConfig);
			} else {
				part.init(config, servletConfig);
				break;
			}
		}
		pluginParts.put(pluginInterface, pluginPartList.get(0));
	}

	/**
	 * t@C琶ς݂̃vOCIuWFNg擾܂B
	 * @param <T> vOCC^[tF[X̌^
	 * @param clazz vOCC^[tF[X
	 * @return vOCIuWFNg
	 */
	public <T extends PluginPart> T load(Class<T> clazz) {
		T result = clazz.cast(pluginParts.get(clazz));
		return result;
	}
}
