package com.small_it_office.flatserve.core.request;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.small_it_office.flatserve.core.UnexpectedException;
import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.core.request.bean.internal.BeanMappedParameter;
import com.small_it_office.flatserve.core.request.bean.internal.BeanParameterMapper;
import com.small_it_office.flatserve.core.request.bean.internal.BeanParameterMapperFactory;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import com.small_it_office.shared.meslog.message.Message;

/**
 * HTTPNGXgőMꂽi[JavaBeañCX^X𐶐NXłB
 * w肳ꂽJavaBeanNX̃CX^X𐶐A
 * NGXgp[^܂̓NGXg{fB̓etB[hɊi[܂B
 * ȉ̂ꂩ̏𖞂tB[hɊY郊NGXgp[^̒l܂̓{fB̂̂i[܂B
 * <ul>
 * <li>tB[h̖ONGXgp[^̖OiHttpServletRequestgetParameterŎw肷閼Ojƈv</li>
 * <li>tB[h@Paramw肵ANGXgp[^̖Ow肵Ă</li>
 * <li>tB[ȟ^byte[]łiNGXg{fBŜi[܂j</li>
 * <li>String̃tB[h@RequestBodyw肵Ă</li>
 * </ul>
 */
public class Populator {

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * ̃NX̃CX^XB
	 */
	private static Populator instance = new Populator();

	/**
	 * RXgN^B
	 */
	private Populator() {
	}

	/**
	 * CX^XԂ܂B
	 * @return Populator̃CX^XB
	 */
	public static Populator getInstance() {
		return instance;
	}

	/**
	 * JavaBeañCX^X𐶐ANGXgi[ĕԂ܂B
	 * @param <T> JavaBeaň^B
	 * @param beanType JavaBeañNXB
	 * @return NGXg񂪊i[ꂽJavaBeañCX^XB
	 */
	public <T> T populate(Class<T> beanType) {
		logger.info("FS-LOGI010");
		logger.debug("FS-LOGD051", beanType.getName());

		BeanParameterMapper reader = BeanParameterMapperFactory.getInstance().getReader();

		T bean = createInstance(beanType);
		logger.debug("FS-LOGD021", bean.getClass().getName());
		List<Field> fields = searchAllFields(beanType);

		RequestContext context = RequestContext.get();
		Map<String, Object> rawData = new HashMap<String, Object>();
		for (Field field : fields) {
			logger.debug("FS-LOGD052", field.getName());
			if (rawData.containsKey(field.getName())) {
				logger.debug("FS-LOGD054", field.getDeclaringClass().getName(), field.getName());
				continue;
			}
			field.setAccessible(true);
			BeanMappedParameter param = new BeanMappedParameter();
			param = reader.process(field, param);
			if (param.getParam() != null || !field.getType().isPrimitive()) {
				try {
		            field.set(bean, param.getParam());
	            } catch (IllegalAccessException e) {
	            	throw new UnexpectedException(e);
	            }
				logger.debug("FS-LOGD050", beanType.getName(), field.getName(), param.getParam());
			}
			rawData.put(param.getParamName(), param.getRawParam());
			logger.debug("FS-LOGD053", field.getName());
		}

		context.setPopulatedBean(bean);
		context.setPopulatedBeanRawData(rawData);

		logger.debug("FS-LOGD022", bean.getClass().getName());
		logger.info("FS-LOGI011");
		return bean;
	}

	/**
	 * w肳ꂽNX̃CX^X𐶐܂B
	 * ȂRXgN^tNVŌĂяo܂BȂRXgN^݂Ȃꍇ͗O܂B
	 * @param <T> IuWFNǧ^B
	 * @param beanType CX^X𐶐NXB
	 * @return ꂽIuWFNgB
	 */
	private <T> T createInstance(Class<T> beanType) {
		T bean;
		try {
			bean = beanType.newInstance();
		} catch (Exception e) {
			throw new ParameterMappingException(Message.get("FS-ERR012", beanType.getName()), e);
		}
		return bean;
	}

	/**
	 * NX̑StB[h̃XgԂ܂B
	 * eNX̃tB[hׂăXgɊ܂܂܂B
	 * @param beanType Ώۂ̃NXB
	 * @return StB[h̃XgB
	 */
	private List<Field> searchAllFields(Class<?> beanType) {
		List<Field> fields = new ArrayList<Field>();
		Class<?> currentClass = beanType;
		while (currentClass != Object.class) {
			Field[] fieldArray = currentClass.getDeclaredFields();
			fields.addAll(Arrays.asList(fieldArray));
			currentClass = currentClass.getSuperclass();
		}
		return fields;
	}

}
