package com.small_it_office.flatserve.core.request.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

import javax.servlet.ServletConfig;

import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.plugin.internal.PluginPart;
import com.small_it_office.flatserve.core.request.bean.internal.BeanParameterMapperFactory;
import com.small_it_office.flatserve.core.request.bean.internal.BeanParameterMapperImpl;
import com.small_it_office.flatserve.core.request.type.internal.MappedParameter;
import com.small_it_office.flatserve.core.request.type.internal.TypeMapping;
import com.small_it_office.flatserve.core.request.type.internal.TypeMappingFactory;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;

/**
 * {@link RequestParameterReader}ɂēǂݍ񂾒lAw肳ꂽ\bhɓnɃ}bsONXłB
 */
public class RequestParameterMapperImpl implements RequestParameterMapper {

	/**
	 * ̃vOCi̗D揇ʁB
	 */
	private static final int PLUGIN_PRIORITY = 1024;

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * {@inheritDoc}
	 */
	public ParameterHolder process(Class<?> serviceClass, Method method, ParameterHolder mappedParams) {
		logger.debug("FSCORE-LOGD014");

		Class<?>[] paramTypes = method.getParameterTypes();
		Annotation[][] paramAnnotations = method.getParameterAnnotations();
		for (int i = 0; i < paramTypes.length; i++) {
			Class<?> type = paramTypes[i];
			Annotation[] annotations = paramAnnotations[i];
			TypeMapping typeMapping = TypeMappingFactory.getInstance().getMapping(type);
			MappedParameter mappedParam;
			logger.debug("FSCORE-LOGD004", method.getName(), i + 1);

			mappedParam = typeMapping.mapParameter(annotations, mappedParams.getParam(i));

			logger.debug("FSCORE-LOGD005", method.getName(), i + 1);
			if (mappedParam != null) {
				mappedParams.setRawParam(i, mappedParam.getRawParam());
				mappedParams.setParam(i, mappedParam.getParam());
			}
			if (mappedParams.getParam(i) == NullObject.getInstance()) {
				mappedParams.setParam(i, null);
			}
		}

		logger.debug("FSCORE-LOGD015");
		return mappedParams;
	}

	/**
	 * {@inheritDoc}
	 */
	public void init(Config config, ServletConfig servletConfig) {
		BeanParameterMapperFactory.getInstance().addReader(servletConfig, new BeanParameterMapperImpl());
	}

	/**
	 * {@inheritDoc}
	 */
	public boolean nest() {
		return false;
	}

	/**
	 * {@inheritDoc}
	 */
	public int priority() {
		return PLUGIN_PRIORITY;
	}

	/**
	 * {@inheritDoc}
	 */
	public void setNestedObject(PluginPart o) {
	}

}
