package com.small_it_office.flatserve.core.request.type.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.small_it_office.flatserve.core.UnexpectedException;
import com.small_it_office.flatserve.core.request.ParameterMappingException;
import com.small_it_office.flatserve.core.request.bean.internal.BeanMappedParameter;
import com.small_it_office.flatserve.core.request.bean.internal.BeanParameterMapper;
import com.small_it_office.flatserve.core.request.bean.internal.BeanParameterMapperFactory;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import com.small_it_office.shared.meslog.message.Message;

/**
 * HTTPT[rX\bḧJavaBean̏ꍇɃNGXgp[^Ƃ̃}bsOs܂B
 */
public class BeanTypeMapping implements TypeMapping {

	/**
	 * ΏۂJavaBeanNXB
	 */
	private Class<?> beanType;

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * RXgN^B
	 * @param beanType ΏۂJavaBeañNX
	 */
	public BeanTypeMapping(Class<?> beanType) {
		this.beanType = beanType;
	}

	/**
	 * {@inheritDoc}
	 */
	public MappedParameter mapParameter(Annotation[] annotations, Object readParam) {
		logger.debug("FS-LOGD020", beanType.getName(), this.getClass().getSimpleName());
		if (readParam != null) {
			//readParamNullObjectꍇ}bsOsȂB
			//vOCŏ݂ƂƂ́AėpIBeanł͂ȂvOCŗpp̌^ƂƁB
			logger.debug("FS-LOGD046", readParam);
			return null;
		}

		Object bean;
		try {
			bean = beanType.newInstance();
		} catch (Exception e) {
			throw new ParameterMappingException(Message.get("FS-ERR012", beanType.getName()), e);
		}
		logger.debug("FS-LOGD021", bean.getClass().getName());
		List<Field> fields = searchAllFields(beanType);

		BeanParameterMapper reader = BeanParameterMapperFactory.getInstance().getReader();
		Map<String, Object> rawParams = new HashMap<String, Object>();
		for (Field field : fields) {
			logger.debug("FS-LOGD052", field.getName());
			if (rawParams.containsKey(field.getName())) {
				//OfieldꍇA̓TuNXŃI[o[ChꂽtB[hłA
				//ǂݎ邱Ƃ͂ȂB
				//fieldśApKw̉̃NXɂtB[h珇ɕł̂ŁAÕtB[hꍇ
				//ŏɌ̂LB
				logger.debug("FS-LOGD054", field.getDeclaringClass().getName(), field.getName());
				continue;
			}
			field.setAccessible(true);
			//BeanMappedParameteŕAreader̃`F[̒ŒlZbgB
			BeanMappedParameter fieldParam = new BeanMappedParameter();
			fieldParam = reader.process(field, fieldParam);

			if (fieldParam.getParam() != null || !field.getType().isPrimitive()) {
				try {
                	field.set(bean, fieldParam.getParam());
                } catch (IllegalAccessException e) {
                	throw new UnexpectedException(e);
                }
				logger.debug("FS-LOGD050", beanType.getName(), field.getName(), fieldParam.getParam());
			}
			rawParams.put(fieldParam.getParamName(), fieldParam.getRawParam());
			logger.debug("FS-LOGD053", field.getName());
		}

		logger.debug("FS-LOGD022", beanType.getName());
		return new MappedParameter(bean, rawParams);
	}

	/**
	 * NX̑StB[h̃XgԂ܂B
	 * eNX̃tB[hׂăXgɊ܂܂܂B
	 * @param beanType Ώۂ̃NXB
	 * @return StB[h̃XgB
	 */
	private List<Field> searchAllFields(Class<?> beanType) {
		List<Field> fields = new ArrayList<Field>();
		Class<?> currentClass = beanType;
		while (currentClass != Object.class) {
			Field[] fieldArray = currentClass.getDeclaredFields();
			fields.addAll(Arrays.asList(fieldArray));
			currentClass = currentClass.getSuperclass();
		}
		return fields;
	}
}
