package com.small_it_office.flatserve.core.request.type.internal;

import java.lang.annotation.Annotation;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.core.request.internal.NullObject;
import com.small_it_office.flatserve.core.request.internal.ParamNameConstants;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;


/**
 * HTTPT[rX\bḧ̌^HttpServletResponsȅꍇ̃}bsOs܂B
 * mapParameter\bh́ÃReLXg񂩂擾HttpServletResponseIuWFNgPɕԂ܂B
 */
public class HttpServletResponseTypeMapping implements TypeMapping {

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * {@inheritDoc}
	 */
	public MappedParameter mapParameter(Annotation[] annotations, Object readParam) {
		logger.debug("FS-LOGD020", HttpServletResponse.class.getName(), this.getClass().getSimpleName());
		if (readParam != null && readParam != NullObject.getInstance()) {
			logger.debug("FS-LOGD046", readParam);
			return null;
		}
		Map<String, Object> requestParams = RequestContext.get().getRequestParams();
		HttpServletResponse value = (HttpServletResponse)requestParams.get(ParamNameConstants.HTTP_SERVLET_RESPONSE);
		MappedParameter result = new MappedParameter(value, value);

		logger.debug("FSCORE-LOGD008");
		return result;
	}

}
