package com.small_it_office.flatserve.core.request.type.internal;

import java.lang.annotation.Annotation;

import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.core.request.Param;
import com.small_it_office.flatserve.core.request.internal.NullObject;
import com.small_it_office.flatserve.core.util.internal.AnnotationUtil;
import com.small_it_office.flatserve.core.util.internal.StringUtil;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;


/**
 * HTTPT[rX\bḧString̔z^̏ꍇɃNGXgp[^Ƃ̃}bsOs܂B
 * ̃NXmapParameter\bh́AT[rX\bḧ@ParamAme[V
 * w肳ꂽp[^擾AY郊NGXgp[^̒lԂ܂B
 */
public class StringArrayTypeMapping implements TypeMapping {

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * {@inheritDoc}
	 */
	public MappedParameter mapParameter(Annotation[] annotations, Object readParam) {
		logger.debug("FS-LOGD020", "String[]", this.getClass().getSimpleName());
		if (readParam != null && readParam != NullObject.getInstance()) {
			if (logger.isDebugEnabled()) {
				logger.debug("FS-LOGD046", StringUtil.arrayToString((String[])readParam));
			}
			return null;
		}

		Param paramAnnotation = AnnotationUtil.findAnnotation(annotations, Param.class);
		if (paramAnnotation != null) {
			String[] paramValues = null;
			String requestParamName = paramAnnotation.value();
			Object objParam = RequestContext.get().getRequestParams().get(requestParamName);
			if (objParam == null) {
				logger.debug("FS-LOGD025", requestParamName);
			} else if (objParam instanceof String[]) {
				if (logger.isDebugEnabled()) {
					logger.debug("FS-LOGD026", requestParamName, StringUtil.arrayToString(paramValues));
				}
				paramValues = (String[])objParam;
			} else {
				logger.debug("FS-LOGW003", requestParamName, objParam);
			}
			MappedParameter mappedParam = new MappedParameter(paramValues, paramValues);
			return mappedParam;
		}

		logger.debug("FS-LOGD027", "String[]");
		return null;
	}

}
