package com.small_it_office.flatserve.core.request.type.internal;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * {@link TypeMapping}̃t@NgłB
 * HTTPT[rX\bḧ̌^ɉ}bsONX̃CX^XԂ܂B
 */
public class TypeMappingFactory {

	/**
	 * ̃NX̃CX^XB
	 */
	private static TypeMappingFactory instance = new TypeMappingFactory();

	/**
	 * ^RequestParameterMapping̑ΉێMapB
	 */
	private Map<Class<?>, TypeMapping> typeMapping = new HashMap<Class<?>, TypeMapping>();

	/**
	 * RXgN^B
	 */
	private TypeMappingFactory() {
		typeMapping.put(String.class, new StringTypeMapping());
		typeMapping.put(String[].class, new StringArrayTypeMapping());
		typeMapping.put(HttpServletRequest.class, new HttpServletRequestTypeMapping());
		typeMapping.put(HttpServletResponse.class, new HttpServletResponseTypeMapping());
		typeMapping.put(ServletConfig.class, new ServletConfigTypeMapping());
		typeMapping.put(byte[].class, new ByteArrayTypeMapping());
	}

	/**
	 * ̃NX̃CX^XԂ܂B
	 * @return RequestParameterMappingFactorỹCX^XB
	 */
	public static TypeMappingFactory getInstance() {
		return instance;
	}

	/**
	 * w肵^ɑΉ{@link TypeMapping}IuWFNgԂ܂B
	 * @param type ^킷NX
	 * @return RequestParameterMappingIuWFNg
	 */
	public TypeMapping getMapping(Class<?> type) {
		TypeMapping mapping = typeMapping.get(type);
		if (mapping == null) {
			if (type.isPrimitive() || type.isArray() || type.getName().startsWith("java")) {
				return new UnsupportedTypeMapping(type);
			}
			return new BeanTypeMapping(type);
		}
		return mapping;
	}
}
