package com.small_it_office.flatserve.core.response;

import java.io.IOException;

import javax.servlet.http.HttpServletResponse;

import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import com.small_it_office.shared.meslog.message.Message;

/**
 * oCgzɂ鉞킷NXłB
 * ̃NX̃IuWFNgHTTPT[rX\bh̖߂lƂĕԂƂŁA
 * oCgzŕԂƂł܂B
 * content-typeRɐݒ\Ȃ̂ŁACӂ̉ɔėpIɗpł܂B
 */
public class ByteArrayResponse extends Response {

	/**
	 * content-typewb_B
	 * ftHgapplication/octet-streamB
	 */
	private String contentType = "application/octet-stream";

	/**
	 * X|X{fBB
	 */
	private byte[] content = new byte[0];

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * content-typewb_̒lԂ܂B
	 * @return content-typewb_̒l
	 */
	public String getContentType() {
		return contentType;
	}

	/**
	 * content-typewb_̒lݒ肵܂B
	 * @param contentType content-typewb_̒l
	 */
	public void setContentType(String contentType) {
		this.contentType = contentType;
	}

	/**
	 * X|X{fB̓e擾܂B
	 * @return X|X{fB̓e
	 */
	public byte[] getContent() {
		return content.clone();	//findbugs[EI]Ή
	}

	/**
	 * X|X{fB̓eݒ肵܂B
	 * @param content X|X{fB̓e
	 */
	public void setContent(byte[] content) {
		if (content == null) {
			throw new IllegalArgumentException(Message.get("FS-ERR017", this.getClass().getSimpleName()));
		}
		this.content = content.clone();	//findbugs[EI2]Ή
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void writeResponse() throws IOException {
		HttpServletResponse response = RequestContext.get().getHttpServletResponse();

		logger.debug("FSCORE-LOGD010");
		response.getOutputStream().write(content);
		logger.debug("FSCORE-LOGD011");

	}
}
