package com.small_it_office.flatserve.core.response.internal;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletResponse;

import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.plugin.internal.PluginPart;
import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.core.response.Response;
import com.small_it_office.flatserve.core.response.ResponseFailException;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import com.small_it_office.shared.meslog.message.Message;

/**
 * HTTPT[rX\bh̖߂lHTTPőMNXłB
 * <p>
 * IuWFNǧ^𔻒fđM@肵܂B
 * ƂđMIuWFNǵAȉ̂ꂩ̌^łKv܂B
 * ȊǑ^̃IuWFNgresponseObjectŎ󂯎ꍇA
 * ResponseFailExceptionthrow܂B
 * </p>
 * <ul>
 * <li>java.lang.String</li>
 * <li>byte[]</li>
 * <li>{@link Response}̃TuNX</li>
 * </ul>
 */
public class ResponseSenderImpl implements ResponseSender {

	/**
	 * ̃vOCi̗D揇ʁB
	 */
	private static final int PLUGIN_PRIORITY = 1024;

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * {@inheritDoc}
	 */
	public void process(Object responseObject) throws IOException {
		if (responseObject == null) {
			logger.debug("FS-LOGD035");
			return;
		}
		HttpServletResponse response = RequestContext.get().getHttpServletResponse();

		logger.debug("FS-LOGD036", responseObject.getClass().getName());
		if (responseObject instanceof String) {
			String textRes = (String)responseObject;
			response.setContentType("text/plain");
			response.setCharacterEncoding("UTF-8");
			PrintWriter out = response.getWriter();
			out.write(textRes);
		} else if (responseObject instanceof byte[]) {
			response.setContentType("application/octet-stream");
			response.getOutputStream().write((byte[])responseObject);
		} else if (responseObject instanceof Response) {
			Response webResponse = (Response)responseObject;
			webResponse.sendResponse();
		} else {
			throw new ResponseFailException(Message.get("FS-ERR018", responseObject.getClass().getName()));
		}
		response.flushBuffer();
	}

	/**
	 * ̃vOCi̓lXgi܂B
	 * @return false
	 * @see PluginPart#nest()
	 */
	public boolean nest() {
		return false;
	}

	/**
	 * ̃vOCi̓lXgiȂ߁Ã\bh͉s܂B
	 * @param o lXgvOCi
	 * @see PluginPart#setNestedObject(PluginPart)
	 */
	public void setNestedObject(PluginPart o) {
		//NOP
	}

	/**
	 * {@inheritDoc}
	 */
	public void init(Config config, ServletConfig servletConfig) {
		//NOP
	}

	/**
	 * ̃vOCi̗D揇ʂłB
	 * 1024Ԃ܂B
	 * @return 1024
	 * @see PluginPart#priority()
	 */
	public int priority() {
		return PLUGIN_PRIORITY;
	}
}
