package com.small_it_office.flatserve.core.service.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import javax.servlet.ServletConfig;


import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import com.small_it_office.shared.meslog.message.Message;
import com.small_it_office.flatserve.core.UnexpectedException;
import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.plugin.internal.PluginPart;
import com.small_it_office.flatserve.core.service.HttpServiceException;

/**
 * HTTPT[rX\bhsNXłB
 */
public class HttpServiceExecutorImpl implements HttpServiceExecutor {

	/**
	 * ̃vOCi̗D揇ʁB
	 */
	private static final int PLUGIN_PRIORITY = 1024;

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * {@inheritDoc}
	 */
	public Object execute(Method method, Object[] params, Object serivce) {
		logger.info("FS-LOGI006", serivce.getClass().getName(), method.getName());
		Object responseObject;
		try {
			responseObject = method.invoke(serivce, params);
		} catch (InvocationTargetException e) {
			Throwable cause = e.getTargetException();
			if (cause instanceof RuntimeException) {
				throw (RuntimeException)cause;
			} else if (cause instanceof Error) {
				throw (Error)cause;
			}
			throw new HttpServiceException(Message.get("FS-ERR009"), e.getTargetException());
		} catch (Throwable e) {
			throw new UnexpectedException(e);
		}
		logger.info("FS-LOGI007", serivce.getClass().getName(), method.getName());
		return responseObject;
	}

	/**
	 * ̃vOCi̓lXgi܂B
	 * @return false
	 * @see PluginPart#nest()
	 */
	public boolean nest() {
		return false;
	}

	/**
	 * ̃vOCi̓lXgiȂ߁Ã\bh͉s܂B
	 * @param o lXgvOCi
	 * @see PluginPart#setNestedObject(PluginPart)
	 */
	public void setNestedObject(PluginPart o) {
		//NOP
	}

	/**
	 * {@inheritDoc}
	 */
	public void init(Config config, ServletConfig servletConfig) {
		//NOP
	}

	/**
	 * ̃vOCi̗D揇ʂłB
	 * 1024Ԃ܂B
	 * @return 1024
	 * @see PluginPart#priority()
	 */
	public int priority() {
		return PLUGIN_PRIORITY;
	}
}
