package com.small_it_office.flatserve.aop;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;


import org.aopalliance.intercept.MethodInterceptor;


import com.small_it_office.shared.meslog.message.Message;
import com.small_it_office.flatserve.aop.internal.AnnotationAssignedAspect;
import com.small_it_office.flatserve.aop.internal.Aspect;
import com.small_it_office.flatserve.aop.internal.ClassAssignedAspect;
import com.small_it_office.flatserve.aop.internal.HttpServiceMethodInterceptorWrapper;
import com.small_it_office.flatserve.aop.internal.PackageAssignedAspect;

/**
 * AXyNg̒`ێNXłB
 * ̃NX̃CX^X{@link com.small_it_office.flatserve.core.config.Config#addOptionalConfig(Object)}\bh
 * ConfigIuWFNgɊi[邱ƂŁAAXyNg̒`LɂȂ܂B
 * <p>
 * AXyNg̒`́AI[o[[hꂽaddAspect\bhgĒǉ܂B
 * HTTPT[rX\bhɑ΂ēKpC^[Zv^́A`ǉꂽԂǂɎs܂B
 * </p>
 * <p>
 * addAspect\bhŃAXyNgɑgݍނƂłC^[Zv^́A
 * <a href="http://aopalliance.sourceforge.net/">AOP alliance</a>dlŒ`org.aopalliance.intercept.MethodInterceptor
 * сA{@link HttpServiceMethodInterceptor}̎NXłB
 * </p>
 * <p>
 * org.aopalliance.intercept.MethodInterceptorC^[tF[XNXC^[Zv^Ƃ邱ƂŁA
 * ̃C^[Zv^̎FlatServeȊOAOP Alliancẽt[[Nōėp邱Ƃł܂B
 * ܂AtɁÃt[[Npɍ쐬ꂽorg.aopalliance.intercept.MethodInterceptorC^[tF[X̎NXA
 * FlatServe AOP Pluginōėp邱Ƃ\łB
 * </p>
 * <p>
 * {@link HttpServiceMethodInterceptor}́AAOP Allianceł͂܂񂪁Ap@MethodInterceptorƂقړłB
 * MethodInterceptorƌ݊͂ȂȂ܂AT[ubgFlatServeL̃IuWFNgƂł郁bg
 * ܂B
 * </p>
 * @see com.small_it_office.flatserve.core.config.Config
 * @see <a href="http://aopalliance.sourceforge.net/">AOP alliance</a>
 */
public class AspectConfig {

	/**
	 * AXyNg̒`ێ郊XgB
	 */
	private List<Aspect> aspectList = new ArrayList<Aspect>();

	/**
	 * RXgN^B
	 */
	public AspectConfig() {
		Message.load("flatserve-aop-messages");
	}

	/**
	 * AXyNg̒`ǉ܂B
	 * ̃\bḧŎw肵C^[Zv^́AׂĂHTTPT[rX\bhɑ΂ēKp܂B
	 * @param interceptor AOP alliancedlɂC^[Zv^
	 */
	public void addAspect(MethodInterceptor interceptor) {
		if (interceptor == null) {
			throw new IllegalArgumentException(Message.get("FSAOP-ERR003"));
		}
		aspectList.add(new Aspect(interceptor));
	}

	/**
	 * AXyNg̒`ǉ܂B
	 * targetServiceClassŎw肵HTTPT[rXNXsꍇ̂݁Aw肵C^[Zv^Kp܂B
	 * @param interceptor AOP alliancedlɂC^[Zv^
	 * @param targetServiceClass Kp\HTTPT[rXNX
	 */
	public void addAspect(MethodInterceptor interceptor, Class<?> targetServiceClass) {
		if (interceptor == null) {
			throw new IllegalArgumentException(Message.get("FSAOP-ERR003"));
		}
		if (targetServiceClass == null) {
			throw new IllegalArgumentException(Message.get("FSAOP-ERR004"));
		}
		aspectList.add(new ClassAssignedAspect(interceptor, targetServiceClass));
	}

	/**
	 * AXyNg̒`ǉ܂B
	 * targetPackageŎw肵pbP[WɑHTTPT[rXNXsꍇ̂݁Aw肵C^[Zv^Kp܂B
	 * w肵pbP[W̃TupbP[WHTTPT[rXNXɂ͓Kp܂B
	 * @param interceptor AOP alliancedlɂC^[Zv^
	 * @param targetPackage Kp\HTTPT[rXNX̃pbP[W
	 */
	public void addAspect(MethodInterceptor interceptor, String targetPackage) {
		if (interceptor == null) {
			throw new IllegalArgumentException(Message.get("FSAOP-ERR003"));
		}
		if (targetPackage == null) {
			throw new IllegalArgumentException(Message.get("FSAOP-ERR005"));
		}
		aspectList.add(new PackageAssignedAspect(interceptor, targetPackage));
	}

	/**
	 * AXyNg̒`ǉ܂B
	 * annotationŎw肵Ame[VHTTPT[rXNXɕt^Ăꍇ̂݁A
	 * w肵C^[Zv^Kp܂B
	 * @param interceptor AOP alliancedlɂC^[Zv^
	 * @param annotation C^[Zv^KpHTTPT[rXNXɕt^ׂAme[V
	 */
	public void addAspectWithAnnotation(MethodInterceptor interceptor, Class<? extends Annotation> annotation) {
		if (interceptor == null) {
			throw new IllegalArgumentException(Message.get("FSAOP-ERR003"));
		}
		if (annotation == null) {
			throw new IllegalArgumentException(Message.get("FSAOP-ERR006"));
		}
		aspectList.add(new AnnotationAssignedAspect(interceptor, annotation));
	}

	/**
	 * AXyNg̒`ǉ܂B
	 * ̃\bḧŎw肵C^[Zv^́AׂĂHTTPT[rX\bhɑ΂ēKp܂B
	 * @param interceptor HTTPT[rX\bhp̃C^[Zv^
	 */
	public void addAspect(HttpServiceMethodInterceptor interceptor) {
		if (interceptor == null) {
			throw new IllegalArgumentException(Message.get("FSAOP-ERR003"));
		}
		addAspect(new HttpServiceMethodInterceptorWrapper(interceptor));
	}

	/**
	 * AXyNg̒`ǉ܂B
	 * targetServiceClassŎw肵HTTPT[rXNXsꍇ̂݁Aw肵C^[Zv^Kp܂B
	 * @param interceptor HTTPT[rX\bhp̃C^[Zv^
	 * @param targetServiceClass Kp\HTTPT[rXNX
	 */
	public void addAspect(HttpServiceMethodInterceptor interceptor, Class<?> targetServiceClass) {
		if (interceptor == null) {
			throw new IllegalArgumentException(Message.get("FSAOP-ERR003"));
		}
		addAspect(new HttpServiceMethodInterceptorWrapper(interceptor), targetServiceClass);
	}

	/**
	 * AXyNg̒`ǉ܂B
	 * targetPackageŎw肵pbP[WɑHTTPT[rXNXsꍇ̂݁Aw肵C^[Zv^Kp܂B
	 * w肵pbP[W̃TupbP[WHTTPT[rXNXɂ͓Kp܂B
	 * @param interceptor HTTPT[rX\bhp̃C^[Zv^
	 * @param targetPackage Kp\HTTPT[rXNX̃pbP[W
	 */
	public void addAspect(HttpServiceMethodInterceptor interceptor, String targetPackage) {
		if (interceptor == null) {
			throw new IllegalArgumentException(Message.get("FSAOP-ERR003"));
		}
		addAspect(new HttpServiceMethodInterceptorWrapper(interceptor), targetPackage);
	}

	/**
	 * AXyNg̒`ǉ܂B
	 * annotationŎw肵Ame[VHTTPT[rXNXɕt^Ăꍇ̂݁A
	 * w肵C^[Zv^Kp܂B
	 * @param interceptor TTPT[rX\bhp̃C^[Zv^
	 * @param annotation C^[Zv^KpHTTPT[rXNXɕt^ׂAme[V
	 */
	public void addAspectWithAnnotation(HttpServiceMethodInterceptor interceptor, Class<? extends Annotation> annotation) {
		if (interceptor == null) {
			throw new IllegalArgumentException(Message.get("FSAOP-ERR003"));
		}
		addAspectWithAnnotation(new HttpServiceMethodInterceptorWrapper(interceptor), annotation);
	}

	/**
	 * `ꂽAXyNg̃XgԂ܂B
	 * @return AXyNg̃Xg
	 */
	public List<Aspect> getAspectList() {
		return aspectList;
	}
}
