package com.small_it_office.flatserve.aop.internal;

import java.util.Locale;

import javax.servlet.ServletConfig;

import com.small_it_office.flatserve.aop.AspectConfig;
import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.plugin.internal.PluginImplementation;
import com.small_it_office.flatserve.core.request.internal.RequestParameterMapper;
import com.small_it_office.flatserve.core.request.internal.RequestParameterReader;
import com.small_it_office.flatserve.core.response.internal.ResponseSender;
import com.small_it_office.flatserve.core.service.internal.HttpServiceExecutor;
import com.small_it_office.flatserve.core.service.internal.HttpServiceFactory;
import com.small_it_office.shared.meslog.message.Message;

/**
 * AOPvOC̎\NXłB
 */
public class AOPPluginImplementation implements PluginImplementation {

	/**
	 * {@inheritDoc}
	 */
	public HttpServiceExecutor getHttpServiceExecutor() {
		return new AspectHttpServiceExecutor();
	}

	/**
	 * {@inheritDoc}
	 */
	public HttpServiceFactory getHttpServiceFactory() {
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	public RequestParameterReader getRequestParameterReader() {
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	public RequestParameterMapper getRequestParameterMapper() {
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	public ResponseSender getResponseSender() {
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	public void init(Config config, ServletConfig servletConfig) {
		if (config.getOptionalConfig(AspectConfig.class) == null) {
			config.addOptionalConfig(new AspectConfig());
		}
		if (!Locale.getDefault().equals(config.getLocale())) {
			Message.clear("flatserve-aop-messages");
			Message.load("flatserve-aop-messages", config.getLocale());
		}
	}

}
