package com.small_it_office.flatserve.aop.internal;

import com.small_it_office.flatserve.core.UnexpectedException;

import org.aopalliance.intercept.MethodInterceptor;

/**
 * C^[Zv^KpΏۃNXwłAXyNgłB
 * w肳ꂽNX̃\bhsꍇ݂̂̃\bhɑ΂ăC^[Zv^KpꍇɎgp܂B
 */
public class ClassAssignedAspect extends Aspect {

	/**
	 * C^[Zv^KpΏۃNXB
	 */
	private Class<?> targetServiceClass;

	/**
	 * RXgN^B
	 * @param interceptor C^[Zv^
	 * @param targetServiceClass C^[Zv^KpΏۂƂNX
	 */
	public ClassAssignedAspect(MethodInterceptor interceptor, Class<?> targetServiceClass) {
		super(interceptor);
		if (targetServiceClass == null) {
			throw new UnexpectedException();
		}
		this.targetServiceClass = targetServiceClass;
	}

	/**
	 * {@inheritDoc}
	 * ̃NXKpΏۃNXłꍇ̂trueԂ܂B
	 */
	public boolean isAssignable(Class<?> serviceClass) {
		return serviceClass == targetServiceClass;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return "class assignable aspect(" + targetServiceClass.getName() + ")";
	}
}
