package com.small_it_office.flatserve.aop.internal;


import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;


import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import com.small_it_office.flatserve.aop.HttpServiceMethodInterceptor;
import com.small_it_office.flatserve.aop.HttpServiceMethodInvocation;

/**
 * HttpServiceMethodInterceptorA<a href="http://aopalliance.sourceforge.net/">AOP alliance</a>`
 * MethodInterceptor^̃IuWFNgƂē\Ƃ邽߂̃bp[łB
 * ̃NX{@link #invoke(MethodInvocation)}\bh́AŕێHttpServiceMethodInterceptor
 * invoke\bhs܂B̂߁AHttpServiceMethodInterceptorbv邱ƂŁAMethodInterceptor
 * ^̌݊Ƃł܂B
 * A{@link #invoke(MethodInvocation)}\bh󂯎́A{@link HttpServiceMethodInvocation}^łȂ
 * Ȃ܂B{@link HttpServiceMethodInvocation}łȂMethodInvoker󂯎ꍇAClassCastException
 * ܂B
 */
public class HttpServiceMethodInterceptorWrapper implements MethodInterceptor {

	/**
	 * bvC^[Zv^B
	 */
	private HttpServiceMethodInterceptor interceptor;

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * RXgN^B
	 * @param interceptor bvΏۂ̃C^[Zv^
	 */
	public HttpServiceMethodInterceptorWrapper(HttpServiceMethodInterceptor interceptor) {
		this.interceptor = interceptor;
	}

	/**
	 * {@inheritDoc}
	 * ŕێHttpServiceMethodInterceptorinvoke\bhs܂B
	 * ́A{@link HttpServiceMethodInvocation}^łȂ΂Ȃ܂B
	 * @throws ClassCastException {@link HttpServiceMethodInvocation}łȂMethodInvoker󂯎ꍇ
	 */
	public Object invoke(MethodInvocation invocation) throws Throwable {
		logger.info("FSAOP-LOGI005", interceptor.getClass().getName());
		return interceptor.invoke((HttpServiceMethodInvocation)invocation);
	}

}
