package com.small_it_office.flatserve.aop.internal;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.aop.HttpServiceMethodInvocation;

/**
 * HTTPT[rX\bh̃WCg|CgƂĕKvȏێNXłB
 */
public class HttpServiceMethodInvocationImpl implements HttpServiceMethodInvocation {

	/**
	 * proceed̍ۂ̐s߁AAspectInvoker̃CX^XێB
	 */
	private AspectInvoker invoker;

	/**
	 * ݒIuWFNgB
	 */
	private Config config;

	/**
	 * sΏۃ\bhB
	 */
	private Method method;

	/**
	 * sΏۃ\bḧB
	 */
	private Object[] arguments;

	/**
	 * \bhsΏۂ̃IuWFNgB
	 */
	private Object target;

	/**
	 * RXgN^B
	 * @param config ݒIuWFNg
	 * @param invoker ̃CX^X𐶐AspectInvoker̃CX^X
	 * @param method sΏۃ\bh
	 * @param arguments sΏۃ\bḧ
	 * @param target \bhsΏۂ̃IuWFNg
	 */
	public HttpServiceMethodInvocationImpl(Config config, AspectInvoker invoker, Method method, Object[] arguments,
	        Object target) {
		this.config = config;
		this.invoker = invoker;
		this.method = method;
		//tB^t@Cɂfindbugs̑Ώۂ珜OARXgN^͎włȂ̂Ń\bhoB
		//\bh𒊏o邱ƂŁAprivate\bh̏ɂȂ̂findbugsoOƂĔFȂȂĂB
		setArguments(arguments);
		this.target = target;
	}

	/**
	 * HTTPT[rX\bhɓnZbgB
	 * @param arguments i[z
	 */
	private void setArguments(Object[] arguments) {
		this.arguments = arguments;
	}

	/**
	 * {@inheritDoc}
	 */
	public HttpServletRequest getHttpServletRequest() {
		return RequestContext.get().getHttpServletRequest();
	}

	/**
	 * {@inheritDoc}
	 */
	public HttpServletResponse getHttpServletResponse() {
		return RequestContext.get().getHttpServletResponse();
	}

	/**
	 * {@inheritDoc}
	 */
	public ServletConfig getServletConfig() {
		return RequestContext.get().getServletConfig();
	}

	/**
	 * {@inheritDoc}
	 */
	public Config getConfig() {
		return config;
	}

	/**
	 * {@inheritDoc}
	 */
	public Method getMethod() {
		return method;
	}

	/**
	 * {@inheritDoc}
	 */
	public Object[] getArguments() {
		return arguments;
	}

	/**
	 * {@inheritDoc}
	 */
	public AccessibleObject getStaticPart() {
		return method;
	}

	/**
	 * {@inheritDoc}
	 */
	public Object getThis() {
		return target;
	}

	/**
	 * {@inheritDoc}
	 */
	public Object proceed() throws Throwable {
		return invoker.proceed();
	}

}
