package com.small_it_office.flatserve.aop.internal;

import com.small_it_office.flatserve.core.UnexpectedException;

import org.aopalliance.intercept.MethodInterceptor;

/**
 * C^[Zv^KpΏۃNX̃pbP[WwłAXyNgłB
 * w肳ꂽpbP[W̃NX̃\bhsꍇ݂̂̃\bhɑ΂ăC^[Zv^KpꍇɎgp܂B
 * TupbP[W͑ΏۂɂȂ܂B
 */
public class PackageAssignedAspect extends Aspect {

	/**
	 * C^[Zv^KpΏۂ̃pbP[WB
	 */
	private String targetPackage;

	/**
	 * RXgN^B
	 * @param interceptor C^[Zv^
	 * @param targetPackage C^[Zv^KpΏۂƂpbP[W
	 */
	public PackageAssignedAspect(MethodInterceptor interceptor, String targetPackage) {
		super(interceptor);
		if (targetPackage == null) {
			throw new UnexpectedException();
		}
		this.targetPackage = targetPackage;
	}

	/**
	 * {@inheritDoc}
	 * ̃NXKpΏۃpbP[W̃NXłꍇ̂trueԂ܂B
	 */
	public boolean isAssignable(Class<?> serviceClass) {
		return serviceClass.getPackage().getName().equals(targetPackage);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return "package assignable aspect(" + targetPackage + ")";
	}
}
