package com.small_it_office.flatserve.multipart.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;

import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

import com.small_it_office.flatserve.core.UnexpectedException;
import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.plugin.internal.PluginPart;
import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.core.request.internal.RequestParameterReader;
import com.small_it_office.flatserve.multipart.FileItem;
import com.small_it_office.flatserve.multipart.MultipartRequestReadException;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;

/**
 * }`p[gNGXgǂݍ݂sRequestParameterReader̎łB
 */
public class MultipartRequestParameterReader implements RequestParameterReader {

	/**
	 * ̃vOCi̗D揇ʁB
	 */
	private static final int PLUGIN_PRIORITY = 256;

	/**
	 * lXgIuWFNgB
	 */
	private RequestParameterReader nested;

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * {@inheritDoc}
	 */
	public Map<String, Object> process(Class<?> serviceClass, Method method, Map<String, Object> params,
	        boolean streamRead, boolean paramRead) {
		logger.debug("FSMPR-LOGD001");
		HttpServletRequest request = RequestContext.get().getHttpServletRequest();
		if (!streamRead && ServletFileUpload.isMultipartContent(request)) {
			processMultiPart(params);
			streamRead = true;
		}
		Map<String, Object> result = nested.process(serviceClass, method, params, streamRead, paramRead);
		logger.debug("FSMPR-LOGD002");
		return result;
	}

	/**
	 * }`p[gNGXg̓ǂݍݏs܂B
	 * @param requestParams ǂݍ񂾃p[^i[MapB
	 */
	private void processMultiPart(Map<String, Object> requestParams) {
		ServletFileUpload fileUpload = new ServletFileUpload();

		Map<String, List<Object>> partMap = new HashMap<String, List<Object>>();
		try {
			FileItemIterator iterator = fileUpload.getItemIterator(RequestContext.get().getHttpServletRequest());
			while (iterator.hasNext()) {
				FileItemStream itemStream = iterator.next();
				String name = itemStream.getFieldName();
				if (requestParams.get(name) != null) {
					logger.debug("FSMPR-LOGD003", name);
					continue;
				}
				List<Object> streams;
				if (partMap.get(name) != null) {
					streams = partMap.get(name);
				} else {
					streams = new ArrayList<Object>();
					partMap.put(name, streams);
				}
				if (itemStream.isFormField()) {
					streams.add(createParamString(itemStream));
				} else {
					streams.add(createFileItem(itemStream));
				}
			}
		} catch (FileUploadException e) {
			throw new MultipartRequestReadException(e);
		} catch (IOException e) {
			throw new MultipartRequestReadException(e);
		}

		Set<String> names = partMap.keySet();
		for (String name : names) {
			List<Object> values = partMap.get(name);
			putRequestParams(requestParams, name, values, values.get(0).getClass());
		}
	}

	/**
	 * Xgŗ^ꂽlAK؂Ȍ^̔zɕϊANGXgp[^ƂMapɊi[܂B
	 * Xg̗vf̌^قȂ̂ꍇ́AMapɂ͉i[܂B
	 * @param <T> XgɊi[ꂽľ^
	 * @param requestParams NGXgp[^i[MapB
	 * @param name p[^B
	 * @param values l̃XgB
	 * @param clazz XgɊi[ꂽľ^B
	 */
	private <T> void putRequestParams(Map<String, Object> requestParams, String name, List<Object> values, Class<T> clazz) {
		@SuppressWarnings("unchecked")
	    T[] requestParam = (T[])Array.newInstance(clazz, values.size());

		for (int i = 0; i < values.size(); i++) {
	    	Object value = values.get(i);
	    	if (value != null && value.getClass() == clazz) {
	    		requestParam[i] = clazz.cast(value);
	    	} else {
	    		return;
	    	}
	    }
    	requestParams.put(name, requestParam);
    }

	/**
	 * Abv[hꂽt@CAFileItemIuWFNg𐶐܂B
	 * @param itemStream Abv[hꂽt@C̃p[gB
	 * @return FileItemIuWFNgB
	 */
	private FileItem createFileItem(FileItemStream itemStream) {
		FileItem fileItem = new FileItem();
		fileItem.setContentType(itemStream.getContentType());
		fileItem.setFileName(itemStream.getName());
		fileItem.setFile(getRequestBodyPart(itemStream));
		return fileItem;
	}

	/**
	 * tH[tB[hɓ͂ꂽ̒l擾܂B
	 * @param itemStream tH[tB[h̃p[gB
	 * @return ̒lB
	 */
	private String createParamString(FileItemStream itemStream) {
		byte[] body = getRequestBodyPart(itemStream);
		String encoding = RequestContext.get().getHttpServletRequest().getCharacterEncoding();
		String paramValue;
		try {
			paramValue = new String(body, encoding);
		} catch (UnsupportedEncodingException e) {
			throw new UnexpectedException(e);
		}
		return paramValue;
	}

	/**
	 * NGXg{fB̃p[gǂݍ݁AoCgzɊi[ĕԂ܂B
	 * @param itemStream }`p[gNGXg̃p[gB
	 * @return Xg[ǂݍ񂾃oCi̔zB
	 */
	private byte[] getRequestBodyPart(FileItemStream itemStream) {
		InputStream is = null;
		ByteArrayOutputStream baos = null;
		try {
			is = itemStream.openStream();
			baos = new ByteArrayOutputStream();
			int b = is.read();
			while (b != -1) {
				baos.write(b);
				b = is.read();
			}
		} catch (IOException e) {
			throw new MultipartRequestReadException(e);
		} finally {
			if (is != null) {
				try {
					is.close();
				} catch (IOException e) {
					e.printStackTrace();
					logger.error("", e.getMessage());
				}
			}
		}

		byte[] body = baos.toByteArray();
		return body;
	}

	/**
	 * {@inheritDoc}
	 */
	public void init(Config config, ServletConfig servletConfig) {
	}

	/**
	 * {@inheritDoc}
	 */
	public boolean nest() {
		return true;
	}

	/**
	 * {@inheritDoc}
	 */
	public int priority() {
		return PLUGIN_PRIORITY;
	}

	/**
	 * {@inheritDoc}
	 */
	public void setNestedObject(PluginPart o) {
		nested = (RequestParameterReader)o;
	}

}
