package com.small_it_office.flatserve.multipart.internal;

import javax.servlet.ServletConfig;

import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.plugin.internal.PluginImplementation;
import com.small_it_office.flatserve.core.request.bean.internal.BeanParameterMapperFactory;
import com.small_it_office.flatserve.core.request.internal.RequestParameterMapper;
import com.small_it_office.flatserve.core.request.internal.RequestParameterReader;
import com.small_it_office.flatserve.core.response.internal.ResponseSender;
import com.small_it_office.flatserve.core.service.internal.HttpServiceExecutor;
import com.small_it_office.flatserve.core.service.internal.HttpServiceFactory;
import com.small_it_office.shared.meslog.message.Message;

/**
 * Multipart Request vOC̎\NXłB
 */
public class MultipartRequestPluginImplementation implements PluginImplementation {

	/**
	 * {@inheritDoc}
	 */
	public HttpServiceExecutor getHttpServiceExecutor() {
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	public HttpServiceFactory getHttpServiceFactory() {
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	public RequestParameterReader getRequestParameterReader() {
		return new MultipartRequestParameterReader();
	}

	/**
	 * {@inheritDoc}
	 */
	public RequestParameterMapper getRequestParameterMapper() {
		return new MultipartRequestParameterMapper();
	}

	/**
	 * {@inheritDoc}
	 */
	public ResponseSender getResponseSender() {
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	public void init(Config config, ServletConfig servletConfig) {
		Message.load("flatserve-multipartrequest-messages", config.getLocale());
		BeanParameterMapperFactory.getInstance().addReader(servletConfig, new MultipartRequestBeanParameterMapper());
	}

}
