package com.small_it_office.flatserve.purehtml.internal;

import java.util.Locale;

import javax.servlet.ServletConfig;

import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.plugin.internal.PluginImplementation;
import com.small_it_office.flatserve.core.request.internal.RequestParameterMapper;
import com.small_it_office.flatserve.core.request.internal.RequestParameterReader;
import com.small_it_office.flatserve.core.response.internal.ResponseSender;
import com.small_it_office.flatserve.core.service.internal.HttpServiceExecutor;
import com.small_it_office.flatserve.core.service.internal.HttpServiceFactory;
import com.small_it_office.flatserve.purehtml.PureHtmlConfig;
import com.small_it_office.shared.meslog.message.Message;


public class PureHtmlPluginImplementation implements PluginImplementation {

	public HttpServiceExecutor getHttpServiceExecutor() {
		return null;
	}

	public HttpServiceFactory getHttpServiceFactory() {
		return null;
	}

	public RequestParameterReader getRequestParameterReader() {
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	public RequestParameterMapper getRequestParameterMapper() {
		return null;
	}

	public ResponseSender getResponseSender() {
		return new PureHtmlResponseSender();
	}

	public void init(Config config, ServletConfig servletConfig) {
		if (config.getOptionalConfig(PureHtmlConfig.class) == null) {
			config.addOptionalConfig(new PureHtmlConfig());
		}
		if (!Locale.getDefault().equals(config.getLocale())) {
			Message.clear("flatserve-purehtml-messages");
			Message.load("flatserve-purehtml-messages", config.getLocale());
		}
	}

}
