package com.small_it_office.flatserve.purehtml.internal;

import java.io.IOException;

import javax.servlet.ServletConfig;

import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.plugin.internal.PluginPart;
import com.small_it_office.flatserve.core.response.internal.ResponseSender;
import com.small_it_office.flatserve.purehtml.PureHtmlConfig;
import com.small_it_office.flatserve.purehtml.PureHtmlResponse;

public class PureHtmlResponseSender implements ResponseSender {

	/**
	 * ̃vOCi̗D揇ʁB
	 */
	private static final int PLUGIN_PRIORITY = 512;

	private PureHtmlConfig config;

	private ResponseSender responseSender;

	public void process(Object responseObject) throws IOException {
		if (responseObject instanceof PureHtmlResponse) {
			PureHtmlResponse htmlResponse = (PureHtmlResponse)responseObject;
			htmlResponse.loadSource(config);
		}

		responseSender.process(responseObject);

	}

	public void init(Config config, ServletConfig servletConfig) {
		this.config = config.getOptionalConfig(PureHtmlConfig.class);
	}

	public boolean nest() {
		return true;
	}

	public int priority() {
		return PLUGIN_PRIORITY;
	}

	public void setNestedObject(PluginPart o) {
		this.responseSender = (ResponseSender)o;
	}

}
