package com.small_it_office.flatserve.purehtml.internal.document;

import java.util.List;

import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.OutputDocument;


public class ImgTagSrcValueModifier implements HtmlTagValueModifier {

	public boolean modifyDocument(OutputDocument outputDocument, List<Element> elements, Object responseValue) {
	    boolean modified = false;
	    Element element = elements.get(0);
	    String attributeName = "src";
	    String newTagText = ModifierUtil.insertAttributeValue(element, attributeName, responseValue);
	    if (newTagText != null) {
	    	outputDocument.replace(element, newTagText);
	    	modified = true;
	    }
	    return modified;
	}

	public boolean responsible(String elementName) {
		return "img".equals(elementName);
	}

}
