package com.small_it_office.flatserve.purehtml.internal.document;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.OutputDocument;


public class InputTagByIdValueModifier implements HtmlTagValueModifier {

	public boolean modifyDocument(OutputDocument outputDocument, List<Element> elements, Object responseValue) {
		boolean modified = false;
		Element element = elements.get(0);
		String type = element.getAttributeValue("type");
		if (type != null) {
			if (ModifierUtil.matchesAny(type.toLowerCase(), "text", "hidden")) {
				String attributeName = "value";
				String newTagText = ModifierUtil.insertAttributeValue(element, attributeName, responseValue);
				if (newTagText != null) {
					outputDocument.replace(element, newTagText);
					modified = true;
				}
			} else if (ModifierUtil.matchesAny(type.toLowerCase(), "checkbox", "radio")) {
				boolean checked;
				if (responseValue instanceof Boolean) {
					checked = (Boolean)responseValue;
				} else if (ModifierUtil.matchesAny(responseValue.toString().toLowerCase(), "false", "")) {
					checked = false;
				} else {
					checked = true;
				}

				Attributes attributes = element.getAttributes();
				Map<String, String> attributesMap = new LinkedHashMap<String, String>();
				attributes.populateMap(attributesMap, false);
				String checkedKey = "checked";
				Set<String> attributeKeys = attributesMap.keySet();
				for (String attributeKey : attributeKeys) {
					if (attributeKey.equalsIgnoreCase("checked")) {
						checkedKey = attributeKey;
						break;
					}
				}

				if (checked) {
					if (!"checked".equalsIgnoreCase(attributesMap.get(checkedKey))) {
						attributesMap.put(checkedKey, "checked");
						modified = true;
					}
				} else {
					if (attributesMap.containsKey(checkedKey)) {
						attributesMap.remove(checkedKey);
						modified = true;
					}
				}
				if (modified) {
					outputDocument.replace(attributes, attributesMap);
				}
			}
		}
		return modified;
	}

	public boolean responsible(String elementName) {
		return "input".equals(elementName);
	}

}
