package com.small_it_office.flatserve.purehtml.internal.document;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.OutputDocument;


public class InputTagByNameValueModifier implements HtmlTagValueModifier {

	public boolean modifyDocument(OutputDocument outputDocument, List<Element> elementsByName, Object responseValue) {
	    boolean modified = false;
	    Element elementByName = elementsByName.get(0);
	    String type = elementByName.getAttributeValue("type");
	    if (type != null) {
	    	if (ModifierUtil.matchesAny(type.toLowerCase(), "text", "hidden")) {
	    		String attributeName = "value";
	    		String newTagText = ModifierUtil.insertAttributeValue(elementByName, attributeName, responseValue);
	    		if (newTagText != null) {
	    			outputDocument.replace(elementByName, newTagText);
	    			modified = true;
	    		}
	    	} else if ("checkbox".equalsIgnoreCase(type)) {
	    		boolean checked;
	    		if (responseValue instanceof Boolean) {
	    			checked = (Boolean)responseValue;
	    		} else {
	    			checked = responseValue.toString().equals(elementByName.getAttributeValue("value"));
	    		}

	    		Attributes attributes = elementByName.getAttributes();
	    		Map<String, String> attributesMap = new LinkedHashMap<String, String>();
	    		attributes.populateMap(attributesMap, false);
	    		String checkedKey = "checked";
	    		Set<String> attributeKeys = attributesMap.keySet();
	    		for (String attributeKey : attributeKeys) {
	    			if (attributeKey.equalsIgnoreCase("checked")) {
	    				checkedKey = attributeKey;
	    				break;
	    			}
	    		}

	    		if (checked) {
	    			if (!"checked".equalsIgnoreCase(attributesMap.get(checkedKey))) {
	    				attributesMap.put(checkedKey, "checked");
	    				modified = true;
	    			}
	    		} else {
	    			if (attributesMap.containsKey(checkedKey)) {
	    				attributesMap.remove(checkedKey);
	    				modified = true;
	    			}
	    		}
	    		if (modified) {
	    			outputDocument.replace(attributes, attributesMap);
	    		}
	    	} else if ("radio".equalsIgnoreCase(type)) {
	    		for (Element radioElement : elementsByName) {
	    			if ("radio".equalsIgnoreCase(type)) {
	    				Attributes attributes = radioElement.getAttributes();
	    				Map<String, String> attributesMap = new LinkedHashMap<String, String>();
	    				attributes.populateMap(attributesMap, false);
	    				String checkedKey = "checked";
	    				Set<String> attributeKeys = attributesMap.keySet();
	    				for (String attributeKey : attributeKeys) {
	    					if (attributeKey.equalsIgnoreCase("checked")) {
	    						checkedKey = attributeKey;
	    						break;
	    					}
	    				}

	    				if (responseValue.toString().equals(attributesMap.get("value"))) {
	    					if (!"checked".equalsIgnoreCase(attributesMap.get(checkedKey))) {
	    						attributesMap.put(checkedKey, "checked");
	    						modified = true;
	    					}
	    				} else {
	    					if (attributesMap.containsKey(checkedKey)) {
	    						attributesMap.remove(checkedKey);
	    						modified = true;
	    					}
	    				}
	    				if (modified) {
	    					outputDocument.replace(attributes, attributesMap);
	    				}
	    			}
	    		}
	    	}
	    }
	    return modified;
    }

	public boolean responsible(String elementName) {
	    return "input".equals(elementName);
    }

}
