package com.small_it_office.flatserve.purehtml.internal.document;

import java.util.List;

import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.EndTag;
import net.htmlparser.jericho.OutputDocument;
import net.htmlparser.jericho.StartTag;



public class ListTagValueModifier implements HtmlTagValueModifier {

	public boolean modifyDocument(OutputDocument outputDocument, List<Element> elements, Object responseValue) {
	    boolean modified = false;
	    Element element = elements.get(0);
	    if (responseValue instanceof List) {
	    	StartTag start = element.getStartTag();
	    	EndTag end = element.getEndTag();
	    	if (end != null || start.isSyntacticalEmptyElementTag()) {
	    		String liStartTag;
	    		String liEndTag;
	    		Element li = element.getFirstElement("li");
	    		if (li == null) {
	    			liStartTag = "<li>";
	    			liEndTag = "</li>";
	    		} else if (li.getStartTag().isSyntacticalEmptyElementTag()) {
	    			StringBuilder sb = new StringBuilder(li.getStartTag().toString());
	    			sb.deleteCharAt(sb.lastIndexOf("/"));
	    			liStartTag = sb.toString();
	    			liEndTag = "</li>";
	    		} else if (li.getEndTag() == null) {
	    			liStartTag = "<li>";
	    			liEndTag = "</li>";
	    		} else {
	    			liStartTag = li.getStartTag().toString();
	    			liEndTag = li.getEndTag().toString();
	    		}

	    		StringBuilder sb = new StringBuilder();
	    		sb.append(start.toString());
	    		if (start.isSyntacticalEmptyElementTag()) {
	    			sb.deleteCharAt(sb.lastIndexOf("/"));
	    		}
	    		for (Object value : (List<?>)responseValue) {
	    			sb.append(liStartTag);
	    			if (value != null) {
	    				sb.append(value.toString());
	    			}
	    			sb.append(liEndTag);
	    		}
	    		if (end == null) {
	    			sb.append("</").append(start.getName()).append(">");
	    		} else {
	    			sb.append(end.toString());
	    		}
	    		outputDocument.replace(element, sb.toString());
	    		modified = true;
	    	}
	    }
	    return modified;
	}

	public boolean responsible(String elementName) {
		return ModifierUtil.matchesAny(elementName, "ol", "ul");
	}

}
