package com.small_it_office.flatserve.transition.internal;

import java.lang.reflect.Method;

import javax.servlet.ServletConfig;

import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.plugin.internal.PluginPart;
import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.core.service.internal.HttpServiceExecutor;
import com.small_it_office.flatserve.transition.TransitionConfig;
import com.small_it_office.flatserve.transition.WrongTransitionHook;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;

/**
 * ʑJڃ`FbNɑΉHttpServiceExecutor̎NXłB
 * sȉʑJڂ̏ꍇ́AΏۂHTTPT[rX\bhsA㏈̃tbNs܂B
 * ʑJڂȏꍇ́APɓŕێHttpServiceExecutorIuWFNgɈڏ܂B
 */
public class TransitionCheckHttpServiceExecutor implements HttpServiceExecutor {

	/**
	 * ̃vOCi̗D揇ʁB
	 */
	private static final int PLUGIN_PRIORITY = 64;

	/**
	 * lXgHttpServiceExecutorB
	 */
	private HttpServiceExecutor executor;

	/**
	 * sȉʑJڎɌ㏈s߂̃tbNB
	 */
	private WrongTransitionHook hook;

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * {@inheritDoc}
	 * <p>
	 * ReLXg񂩂ʑJڂ̃`FbNʂ擾AłȂꍇɌ㏈̃tbNs܂B
	 * ʑJڂł΁APɃlXgHttpServiceExecutors܂B
	 * </p>
	 */
	public Object execute(Method method, Object[] params, Object service) {
		if ("true".equals(RequestContext.get().getAttribute(TransitionCheckConstants.CHECK_RESULT_STORE_KEY))) {
			return executor.execute(method, params, service);
		} else {
			logger.info("FSTRC-LOGI006");
			return executeWrongTransitionHook();
		}
	}

	/**
	 * sȉʑJڂꍇ̃tbNs܂B
	 * @return tbNԂ߂lBHTTPX|XbZ[WɕϊB
	 */
	private Object executeWrongTransitionHook() {
		String hookName = null;
		if (logger.isInfoEnabled()) {
			hookName = hook.getClass().getName();
		}

		logger.info("FSTRC-LOGI004", hookName);

		RequestContext context = RequestContext.get();
		Object result = hook.wrongTransitionOccured(context.getHttpServletRequest(), context.getHttpServletResponse(),
		        context.getServletConfig());

		logger.info("FSTRC-LOGI005", hookName);

		return result;
	}

	/**
	 * {@inheritDoc}
	 */
	public boolean nest() {
		return true;
	}

	/**
	 * {@inheritDoc}
	 */
	public void init(Config config, ServletConfig servletConfig) {
		TransitionConfig transitionConfig = config.getOptionalConfig(TransitionConfig.class);
		this.hook = transitionConfig.getHook();
	}

	/**
	 * {@inheritDoc}
	 */
	public void setNestedObject(PluginPart o) {
		executor = (HttpServiceExecutor)o;
	}

	/**
	 * {@inheritDoc}
	 */
	public int priority() {
		return PLUGIN_PRIORITY;
	}

}
