package com.small_it_office.flatserve.validator.converter.internal;

import java.lang.annotation.Annotation;

import com.small_it_office.flatserve.core.util.internal.AnnotationUtil;
import com.small_it_office.flatserve.validator.ValidationErrorCategory;
import com.small_it_office.flatserve.validator.internal.MessageResourceHolder;
import com.small_it_office.flatserve.validator.internal.util.ErrorUtil;
import com.small_it_office.flatserve.validator.rule.ItemName;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;

/**
 * ^ϊ邽߂̊NXB
 * vfЂƂ̃NGXgp[^Aєz̊evf
 * ^ϊ̍ۂɎs܂B
 */
public abstract class AbstractTypeConverter implements TypeConverter {

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * ̓͒lAtB[ȟ^ɕϊ܂B
	 * <p>
	 * ͂nullы󕶎̏ꍇ́Ã\bh͌Ăяo܂B
	 * āÃ\bh́AɌ^ϊłꍇ͕K炩̒lԂ܂BnullԂ̂́A
	 * ͒lȂߌ^ϊłȂꍇɌ܂B
	 * </p>
	 * <p>
	 * ̃\bh́Aϊ̌^z̏ꍇAєz̊evf̒l̕ϊ̗̏ꍇɌĂяo܂B
	 * āÃ\bh̎́Az^zɂȂʓIȏłȂ΂Ȃ܂B
	 * </p>
	 * @param stringValue ͂ꂽlB
	 * @param annotations ϊ̈tB[hɕt^ꂽAme[V̔zB
	 * @return ͒l^ϊlB^ϊłȂȂ߃of[VG[ƂꍇnullB
	 */
	protected abstract Object convert(String stringValue, Annotation[] annotations);

	/**
	 * ^ϊłȂꍇ̃of[VG[bZ[WԂ܂B
	 * @param value ^ϊłȂB
	 * @param annotations ϊ̈tB[hɕt^ꂽAme[V̔zB
	 * @return G[bZ[WB
	 */
	protected abstract String getErrorMessage(String value, Annotation[] annotations);

	/**
	 * ͒l̕nullłꍇ́A^ϊ̒lƂēK؂ȒlԂ܂B
	 * ʏ́AIuWFNg^łnullAv~eBu̐l^ł0Ԃ܂B
	 * @return nullɑl
	 */
	protected abstract Object getNullValue();

	/**
	 * {@inheritDoc}
	 */
	public Object getValue(String paramName, String[] stringValues, Annotation[] annotations) {
		if (stringValues == null || stringValues.length == 1 && stringValues[0].length() == 0) {
			//NGXgp[^݂̂ȂA͂łꍇB^of[VG[ɂ͂ȂB
			//@NotNull@NotEmptytĂȂȂAnull܂̓v~eBũftHglnB
			Object nullValue = getNullValue();
			logger.debug("FSVLD-LOGD015", paramName, nullValue);
			return nullValue;
		}

		Object converted = convert(stringValues[0], annotations);
		if (converted == null) {
			logger.debug("FSVLD-LOGD006", paramName, stringValues[0], Integer.class.getName());
			createTypeError(paramName, stringValues[0], annotations);
			return getNullValue();
		}
		logger.debug("FSVLD-LOGD016", paramName, converted);
		return converted;
	}

	/**
	 * ^ϊłȂꍇ̃G[IuWFNg𐶐AReLXgɊi[܂B
	 * @param paramName p[^B
	 * @param stringValue ^ϊłȂ̒lB
	 * @param annotations ϊ̈tB[hɕt^ꂽAme[V̔zB
	 */
	private void createTypeError(String paramName, String stringValue, Annotation[] annotations) {
		ItemName itemNameAnnotation = AnnotationUtil.findAnnotation(annotations, ItemName.class);
		String itemName = null;
		if (itemNameAnnotation != null) {
			itemName = MessageResourceHolder.getInstance().get().getMessage(itemNameAnnotation.value());
		}

		String message = getErrorMessage(stringValue, annotations);
		message = ErrorUtil.addItemNameMessage(itemName, message);
		ErrorUtil.createValidationErrorObject(paramName, stringValue, message, 0, ValidationErrorCategory.TYPE);
	}

}
