package com.small_it_office.flatserve.validator.converter.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;

import com.small_it_office.flatserve.core.util.internal.AnnotationUtil;
import com.small_it_office.flatserve.validator.ValidationErrorCategory;
import com.small_it_office.flatserve.validator.internal.MessageResourceHolder;
import com.small_it_office.flatserve.validator.internal.util.ErrorUtil;
import com.small_it_office.flatserve.validator.rule.ItemName;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;

/**
 * z^ϊNXB
 * žX̗vfϊ邽߂ɁA{@link AbstractTypeConverter}Ăяo܂B
 */
public class ArrayTypeConverter implements TypeConverter {

	/**
	 * ϊ̔z̗vf̌^B
	 * Ⴆint[]ɕϊꍇ́Aint.classB
	 */
	private Class<?> componenType;

	/**
	 * žX̗vf^ϊRo[^B
	 */
	private AbstractTypeConverter baseConverter;

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * RXgN^B
	 * @param componentType ϊ̔z̗vf̌^B
	 * @param componentTypeConverter žX̗vf^ϊRo[^B
	 */
	public ArrayTypeConverter(Class<?> componentType, AbstractTypeConverter componentTypeConverter) {
		super();
		this.componenType = componentType;
		this.baseConverter = componentTypeConverter;
	}

	/**
	 * {@inheritDoc}
	 */
	public Object getValue(String paramName, String[] stringValues, Annotation[] annotations) {
		Object value = Array.newInstance(componenType, stringValues.length);
		for (int i = 0; i < stringValues.length; i++) {
			logger.debug("FSVLD-LOGD036", i);
			if (stringValues[i].length() == 0) {
				//stringValues[i]nullƂƂ͂肦Ȃ̂Ń`FbNȂB
				//@NotNull@NotEmptytĂȂȂAnull܂̓v~eBũftHglnB
				Object nullValue = baseConverter.getNullValue();
				logger.debug("FSVLD-LOGD015", paramName, nullValue);
				Array.set(value, i, nullValue);
				continue;
			}
			//convertĂԁBgetValueł͂ȂB
			Object converted = baseConverter.convert(stringValues[i], annotations);
			if (converted == null) {
				logger.debug("FSVLD-LOGD006", paramName, stringValues[0], Integer.class.getName());
				String message = baseConverter.getErrorMessage(stringValues[i], annotations);
				createTypeError(paramName, stringValues[i], i, message, annotations);
				Array.set(value, i, baseConverter.getNullValue());
			} else {
				logger.debug("FSVLD-LOGD016", paramName, converted);
				Array.set(value, i, converted);
			}
		}
		return value;
	}

	/**
	 * z̊evfɂāA^ϊłȂꍇ̃G[IuWFNg𐶐AReLXgɊi[܂B
	 * @param paramName p[^B
	 * @param stringValue ^ϊłȂ̒lB
	 * @param arrayIndex G[zvf̃CfbNXB
	 * @param message zvf̌^ϊs̃G[bZ[WB
	 * @param annotations ϊ̈tB[hɕt^ꂽAme[V̔zB
	 */
	private void createTypeError(String paramName, String stringValue, int arrayIndex, String message,
	        Annotation[] annotations) {
		ItemName itemNameAnnotation = AnnotationUtil.findAnnotation(annotations, ItemName.class);
		String itemName = null;
		if (itemNameAnnotation != null) {
			itemName = MessageResourceHolder.getInstance().get().getMessage(itemNameAnnotation.value());
		}

		message = ErrorUtil.addItemNameMessage(itemName, message);
		ErrorUtil.createValidationErrorObject(paramName, stringValue, message, arrayIndex, ValidationErrorCategory.TYPE);
	}

}
