package com.small_it_office.flatserve.validator.converter.internal;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * {@link TypeConverter}̃t@NgNXB
 */
public class TypeConverterFactory {

	/**
	 * SingletonCX^XB
	 */
	private static TypeConverterFactory instance = new TypeConverterFactory();

	/**
	 * Ro[^i[MapB
	 */
	private Map<Class<?>, TypeConverter> converterMap = new HashMap<Class<?>, TypeConverter>();

	/**
	 * T|[gΏۊǑ^̏ꍇɓKpAȂRo[^B
	 */
	private TypeConverter unsupportedConverter = new UnsupportedTypeConverter();

	/**
	 * RXgN^B
	 * Ro[^̊eCX^X𐶐܂B
	 */
	private TypeConverterFactory() {
		AbstractTypeConverter integerConverter = new IntegerTypeConverter();
		AbstractTypeConverter primitiveIntConverter = new PrimitiveIntTypeConverter();
		AbstractTypeConverter longConverter = new LongTypeConverter();
		AbstractTypeConverter primitiveLongConverter = new PrimitiveLongTypeConverter();
		AbstractTypeConverter floatConverter = new FloatTypeConverter();
		AbstractTypeConverter primitiveFloatConverter = new PrimitiveFloatTypeConverter();
		AbstractTypeConverter doubleConverter = new DoubleTypeConverter();
		AbstractTypeConverter primitiveDoubleConverter = new PrimitiveDoubleTypeConverter();
		AbstractTypeConverter bigDecimalConverter = new BigDecimalTypeConverter();
		AbstractTypeConverter dateConverter = new DateTypeConverter();
		converterMap.put(Integer.class, new IntegerTypeConverter());
		converterMap.put(Integer[].class, new ArrayTypeConverter(Integer.class, integerConverter));
		converterMap.put(int.class, primitiveIntConverter);
		converterMap.put(int[].class, new ArrayTypeConverter(int.class, primitiveIntConverter));
		converterMap.put(Long.class, new LongTypeConverter());
		converterMap.put(Long[].class, new ArrayTypeConverter(Long.class, longConverter));
		converterMap.put(float.class, primitiveFloatConverter);
		converterMap.put(float[].class, new ArrayTypeConverter(float.class, primitiveFloatConverter));
		converterMap.put(Float.class, new FloatTypeConverter());
		converterMap.put(Float[].class, new ArrayTypeConverter(Float.class, floatConverter));
		converterMap.put(Double.class, new DoubleTypeConverter());
		converterMap.put(Double[].class, new ArrayTypeConverter(Double.class, doubleConverter));
		converterMap.put(double.class, primitiveDoubleConverter);
		converterMap.put(double[].class, new ArrayTypeConverter(double.class, primitiveDoubleConverter));
		converterMap.put(long.class, primitiveLongConverter);
		converterMap.put(long[].class, new ArrayTypeConverter(long.class, primitiveLongConverter));
		converterMap.put(BigDecimal.class, bigDecimalConverter);
		converterMap.put(BigDecimal[].class, new ArrayTypeConverter(BigDecimal.class, bigDecimalConverter));
		converterMap.put(Date.class, dateConverter);
		converterMap.put(Date[].class, new ArrayTypeConverter(Date.class, dateConverter));
	}

	/**
	 * ̃t@NgNX̃CX^XԂ܂B
	 * @return ̃NX̃CX^XB
	 */
	public static TypeConverterFactory getInstance() {
		return instance;
	}

	/**
	 * w肵^ɑ΂ēK؂ȃRo[^Ԃ܂B
	 * @param type ϊ̌^B
	 * @return Ro[^B
	 */
	public TypeConverter getConverter(Class<?> type) {
		TypeConverter converter = converterMap.get(type);
		if (converter == null) {
			return unsupportedConverter;
		}
		return converter;
	}
}
