package com.small_it_office.flatserve.validator.internal;

import java.util.Locale;

import javax.servlet.ServletConfig;

import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.plugin.internal.PluginImplementation;
import com.small_it_office.flatserve.core.request.bean.internal.BeanParameterMapperFactory;
import com.small_it_office.flatserve.core.request.internal.RequestParameterMapper;
import com.small_it_office.flatserve.core.request.internal.RequestParameterReader;
import com.small_it_office.flatserve.core.response.internal.ResponseSender;
import com.small_it_office.flatserve.core.service.internal.HttpServiceExecutor;
import com.small_it_office.flatserve.core.service.internal.HttpServiceFactory;
import com.small_it_office.flatserve.validator.MessageResource;
import com.small_it_office.flatserve.validator.ValidatorConfig;
import com.small_it_office.shared.meslog.message.Message;


/**
 * ValidatorvOC̎\NXłB
 */
public class ValidatorPluginImplementation implements PluginImplementation {

	/**
	 * of[VG[bZ[W̃bZ[W\[XB
	 */
	private MessageResource messageResource;

	/**
	 * {@inheritDoc}
	 */
	public HttpServiceExecutor getHttpServiceExecutor() {
		return new ValidatorHttpServiceExecutor(messageResource);
	}

	/**
	 * {@inheritDoc}
	 */
	public HttpServiceFactory getHttpServiceFactory() {
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	public RequestParameterReader getRequestParameterReader() {
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	public RequestParameterMapper getRequestParameterMapper() {
		return new ValidatorRequestParameterMapper(messageResource);
	}

	/**
	 * {@inheritDoc}
	 */
	public ResponseSender getResponseSender() {
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	public void init(Config config, ServletConfig servletConfig) {
		ValidatorConfig validatorConfig = config.getOptionalConfig(ValidatorConfig.class);
		if (validatorConfig == null) {
			validatorConfig = new ValidatorConfig();
			config.addOptionalConfig(validatorConfig);
		}

		if (!Locale.getDefault().equals(config.getLocale())) {
			Message.clear("flatserve-validator-messages");
			Message.load("flatserve-validator-messages", config.getLocale());
		}

		if (validatorConfig.getMessageLocale() == null) {
			validatorConfig.setMessageLocale(config.getLocale());
		}

		messageResource = new MessageResource(validatorConfig);

		BeanParameterMapperFactory.getInstance().addReader(servletConfig, new ValidatorBeanParameterMapper());
	}

	/**
	 * P̃eXgp\bhB
	 * @return bZ[W\[XB
	 */
	MessageResource getMessageResource() {
		return messageResource;
	}

}
