package com.small_it_office.flatserve.validator.internal.util;

import java.math.BigDecimal;

/**
 * ^ϊs[eBeBNXB
 */
public class TypeConvertUtil {

	/**
	 * RXgN^B
	 */
	private TypeConvertUtil() {
	}

	/**
	 * ̒lBigDecimalɕϊ܂B
	 * <p>
	 * IntegerALongAFloatADoubleAStrinĝꂩ̌^nꂽꍇBigDecimal^ɕϊ܂B
	 * String^̏ꍇ́A𐔒lƂ݂Ȃĕϊ܂B
	 * </p>
	 * <p>
	 * BigDecimal^̒lnꂽꍇ́Â܂ܕԋp܂B܂ALȊǑ^̏ꍇAString^
	 * lƂĎʂłȂꍇɂ́Anullԋp܂B
	 * </p>
	 * @param value ϊ̒l
	 * @return BigDecimal^̒l
	 */
	public static BigDecimal bigDecimalValueOf(Object value) {
		BigDecimal bValue = null;
		if (value instanceof BigDecimal) {
			bValue = (BigDecimal)value;
		} else if (value instanceof Integer) {
			bValue = BigDecimal.valueOf((Integer)value);
		} else if (value instanceof Long) {
			bValue = BigDecimal.valueOf((Long)value);
		} else if (value instanceof Float) {
			bValue = BigDecimal.valueOf((Float)value);
		} else if (value instanceof Double) {
			bValue = BigDecimal.valueOf((Double)value);
		} else if (value instanceof String) {
			try {
				bValue = new BigDecimal((String)value);
			} catch (NumberFormatException e) {
				bValue = null;
			}
		}
		return bValue;
	}

	/**
	 * œnꂽv~eBu^̔zAObject[]ɕϊ܂B
	 * <p>
	 * int[]Along[]Afloat[]Adouble[]^̈󂯎Aevfv~eBubp[Ńbv
	 * Object[]^ɕϊ܂B
	 * </p>
	 * <p>
	 * XIuWFNg̔ziObject[]jłꍇɂ́Â܂ܕԋp܂B܂ALȊO
	 * ^̒lœnꂽꍇɂnullԋp܂B
	 * </p>
	 * @param value z
	 * @return Object[]^ɕϊꂽz
	 */
	public static Object[] autoboxArray(Object value) {
		Object[] objValue = null;
		if (value instanceof Object[]) {
			objValue = (Object[])value;
		} else if (value instanceof int[]) {
			int[] intValues = (int[])value;
			objValue = new Integer[intValues.length];
			for (int i = 0; i < intValues.length; i++) {
				objValue[i] = intValues[i];
			}
		} else if (value instanceof long[]) {
			long[] longValues = (long[])value;
			objValue = new Long[longValues.length];
			for (int i = 0; i < longValues.length; i++) {
				objValue[i] = longValues[i];
			}
		} else if (value instanceof float[]) {
			float[] floatValues = (float[])value;
			objValue = new Float[floatValues.length];
			for (int i = 0; i < floatValues.length; i++) {
				objValue[i] = floatValues[i];
			}
		} else if (value instanceof double[]) {
			double[] doubleValues = (double[])value;
			objValue = new Double[doubleValues.length];
			for (int i = 0; i < doubleValues.length; i++) {
				objValue[i] = doubleValues[i];
			}
		}
		return objValue;
	}

}
