package com.small_it_office.flatserve.validator.rule.internal;

import java.math.BigDecimal;

import com.small_it_office.flatserve.validator.internal.util.TypeConvertUtil;
import com.small_it_office.flatserve.validator.rule.DecimalMin;
import com.small_it_office.flatserve.validator.rule.MessageProcessValidationRule;
import com.small_it_office.flatserve.validator.rule.ValidationRuleException;
import com.small_it_office.shared.meslog.message.Message;


/**
 * lw肳ꂽlȂƂ؂of[V[NXłB
 */
public class DecimalMinRule extends MessageProcessValidationRule<DecimalMin> {

	/**
	 * {@inheritDoc}
	 */
	public boolean isValid(Object value, Object rawValue, DecimalMin annotation) {
		if (rawValue == null || "".equals(rawValue)) {
			return true;
		}

		BigDecimal bValue = TypeConvertUtil.bigDecimalValueOf(value);
		if (bValue == null) {
			return false;
		}

		String strMin = annotation.value();
		boolean allowEquiv = annotation.allowEquiv();

		BigDecimal min;
		try {
			min = new BigDecimal(strMin);
		} catch (NumberFormatException e) {
			throw new ValidationRuleException(Message.get("FSVLD-ERR006", annotation.annotationType().getSimpleName(),
			        strMin), e);
		}

		return (bValue.compareTo(min) == 1) || (allowEquiv && bValue.compareTo(min) == 0);
	}

}
