package com.small_it_office.flatserve.validator.rule.internal;

import com.small_it_office.flatserve.validator.rule.MessageProcessValidationRule;
import com.small_it_office.flatserve.validator.rule.RegexpPattern;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;

/**
 * lw肳ꂽK\p^[Ɉv邱Ƃ؂of[V[NXłB
 */
public class RegexpPatternRule extends MessageProcessValidationRule<RegexpPattern> {

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * {@inheritDoc}
	 */
	public boolean isValid(Object value, Object rawValue, RegexpPattern annotation) {
		if (rawValue == null || "".equals(rawValue)) {
			return true;
		}

		if (!(rawValue instanceof String)) {
			logger.warn("FSVLD-LOGW003", annotation.annotationType().getSimpleName());
			return false;
		}

		String pattern = annotation.value();

		return rawValue.toString().matches(pattern);
	}

}
