package com.small_it_office.flatserve.core.process.internal;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.plugin.internal.PluginLoader;
import com.small_it_office.flatserve.core.request.internal.ParameterHolder;
import com.small_it_office.flatserve.core.request.internal.RequestParameterMapper;
import com.small_it_office.flatserve.core.request.internal.RequestParameterReader;
import com.small_it_office.flatserve.core.response.internal.ResponseSender;
import com.small_it_office.flatserve.core.service.HttpMethod;
import com.small_it_office.flatserve.core.service.HttpService;
import com.small_it_office.flatserve.core.service.internal.HttpServiceExecutor;
import com.small_it_office.flatserve.core.service.internal.HttpServiceFactory;
import com.small_it_office.flatserve.core.service.internal.HttpServiceResolver;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;

/**
 * NGXg𐧌䂷NXłB
 */
public class HttpServiceProcessor {

	/**
	 * HTTPXe[^XR[h"400"B
	 */
	private static final int HTTP_STATUS_BAD_REQUEST = 400;

	/**
	 * HTTPXe[^XR[h"404"B
	 */
	private static final int HTTP_STATUS_NOT_FOUND = 404;

	/**
	 * HTTPXe[^XR[h"405"B
	 */
	private static final int HTTP_STATUS_METHOD_NOT_ALLOWED = 405;

	/**
	 * RequestParameterReader̃CX^XB
	 */
	private RequestParameterReader requestReader;

	/**
	 * RequestParameterMapper̃CX^XB
	 */
	private RequestParameterMapper requestMapper;

	/**
	 * ResponseSender̃CX^XB
	 */
	private ResponseSender responseSender;

	/**
	 * HttpServiceFactorỹCX^XB
	 */
	private HttpServiceFactory serviceFactory;

	/**
	 * HttpServiceExecutor̃CX^XB
	 */
	private HttpServiceExecutor serviceExecutor;

	/**
	 * ݒIuWFNgB
	 */
	private Config config;

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * RXgN^B
	 * @param config ݒ
	 * @param servletConfig ServletConfigIuWFNgB
	 */
	public HttpServiceProcessor(Config config, ServletConfig servletConfig) {
		this.config = config;

		PluginLoader pluginLoader = new PluginLoader(config, servletConfig);
		requestReader = pluginLoader.load(RequestParameterReader.class);
		requestMapper = pluginLoader.load(RequestParameterMapper.class);
		responseSender = pluginLoader.load(ResponseSender.class);
		serviceFactory = pluginLoader.load(HttpServiceFactory.class);
		serviceExecutor = pluginLoader.load(HttpServiceExecutor.class);
	}

	/**
	 * NGXg̎又s܂B
	 * @throws IOException o͗O
	 */
	public void process() throws IOException {
		RequestContext context = RequestContext.get();
		HttpServletRequest request = context.getHttpServletRequest();

		request.setCharacterEncoding(config.getRequestEncoding());

		HttpServiceResolver resolver = new HttpServiceResolver(config);
		resolver.resolveURI(request.getRequestURI(), request.getContextPath());

		Class<?> serviceClass = resolver.getServiceClass();
		Method method = resolver.getServiceMethod();

		if (method == null) {
			logger.info("FSCORE-LOGI005", request.getRequestURI());
			HttpServletResponse response = context.getHttpServletResponse();
			response.setStatus(HTTP_STATUS_NOT_FOUND);
			String serviceNotFoundForwardUrl = config.getServiceNotFoundForwardUrl();
			if (serviceNotFoundForwardUrl != null) {
				try {
					request.getRequestDispatcher(serviceNotFoundForwardUrl).forward(request, response);
				} catch (Throwable e) {
					//ł͗ONĈُIA404mɕԂƂD悷B
					logger.warn("FSCORE-LOGW005");
					e.printStackTrace();
				}
			}
			return;
		} else if (!isHttpMethodSupported(method, request.getMethod())) {
			logger.info("FSCORE-LOGI012", serviceClass.getName(), method.getName(), request.getMethod());
			HttpServletResponse response = context.getHttpServletResponse();
			String protocol = request.getProtocol();
			if (protocol.endsWith("1.0")) {
				response.sendError(HTTP_STATUS_BAD_REQUEST);
			} else {
				response.sendError(HTTP_STATUS_METHOD_NOT_ALLOWED);
			}
			return;
		}

		doProcess(serviceClass, method);
	}

	/**
	 * NGXg̓ǂݍ݁ET[rXsEX|Xԋp̏s܂B
	 * @param serviceClass HTTPT[rXNX
	 * @param method HTTPT[rX\bh
	 * @throws IOException X|Xo͎ɓo͗Oꍇ
	 */
	private void doProcess(Class<?> serviceClass, Method method) throws IOException {

		RequestContext context = RequestContext.get();

		Map<String, Object> requestParams = requestReader.process(serviceClass, method, new HashMap<String, Object>(),
		        false, false);
		context.setRequestParams(requestParams);

		ParameterHolder paramHolder = requestMapper.process(serviceClass, method, new ParameterHolder(method
		        .getParameterTypes().length));

		Object[] params = paramHolder.getParams();
		context.setParams(params);
		context.setRawParams(paramHolder.getRawParams());
		Object service = serviceFactory.create(serviceClass, method);

		Object responseObject = serviceExecutor.execute(method, params, service);

		if (responseObject != null) {
			responseSender.process(responseObject);
		}
	}

	/**
	 * HTTPT[rX\bhAw肵HTTP\bhł̎sT|[gĂ邩Ԃ܂B
	 * @param serviceMethod HTTPT[rX\bhB
	 * @param httpMethod GETAPOSTȂǂHTTP\bhB
	 * @return T|[gĂtrueB
	 */
	private boolean isHttpMethodSupported(Method serviceMethod, String httpMethod) {
		HttpService service = serviceMethod.getAnnotation(HttpService.class);
		HttpMethod[] supportedMethods = service.method();
		for (HttpMethod supportedMethod : supportedMethods) {
			if (supportedMethod.matchesName(httpMethod)) {
				return true;
			}
		}
		return false;
	}
}
