package com.small_it_office.flatserve.core.process.internal;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;

/**
 * NGXgɊւReLXgƂĕێ邽߂̃NXłB
 * <p>
 * ̃NX̃IuWFNǵANGXgMƂɐA
 * HttpServletRequestAHttpServletResponseAServletConfigێ܂B
 * ̃IuWFNgeŎ܂Ă邽߁ANGXgMĂ烌X|XԂ܂ł
 * ׂĂ̍HŃReLXgɃANZX邱Ƃł܂B
 * </p>
 * <p>
 * {@link #create(HttpServletRequest, HttpServletResponse, ServletConfig)}ŐꂽCX^X́A
 * Xbh[Jϐɕێ܂B{@link #get()}gƕێꂽCX^X擾邱Ƃł܂B
 * Xbh[JɕێꂽCX^Xւ̃ANZX́AɃCX^XnƂłȂӏł̂
 * gpׂłBʏ́AȂǂŃCX^X󂯓n悤ɂ܂B
 * </p>
 * <p>
 * {@link #create(HttpServletRequest, HttpServletResponse, ServletConfig)}ŃCX^X𐶐A
 * ̃CX^XsvɂȂ_ŕK{@link #clear()}sāAXbh[JϐNAKv܂B
 * </p>
 */
public class RequestContext {

	/**
	 * CX^XێXbh[JϐB
	 */
	private static ThreadLocal<RequestContext> threadLocalInstance = new ThreadLocal<RequestContext>();

	/**
	 * HttpservletRequestIuWFNgB
	 */
	private HttpServletRequest httpServletRequest;

	/**
	 * HttpServletResponseIuWFNgB
	 */
	private HttpServletResponse httpServletResponse;

	/**
	 * ServletConfigIuWFNgB
	 */
	private ServletConfig servletConfig;

	/**
	 * {@link com.small_it_office.flatserve.core.request.internal.RequestParameterReader}ɂēǂݍ񂾃NGXgp[^MapB
	 */
	private Map<String, Object> requestParams;

	/**
	 * HTTPNGXgǂݍ񂾁AHTTPT[rX\bḧɃ}bsOlB
	 * ^ϊsO̒lBHTMLtH[̃NGXgp[^ȂString^łB
	 */
	private Object[] rawParams;

	/**
	 * HTTPT[rX\bḧɃCWFNVlB
	 */
	private Object[] params;

	/**
	 * {@link com.small_it_office.flatserve.core.request.Populator}ɂăNGXgp[^i[ꂽBeanB
	 */
	private Object populatedBean;

	/**
	 * {@link com.small_it_office.flatserve.core.request.Populator}ɂBean𐶐邽߂HTTPNGXgǂݍ񂾒lB
	 * L[̓NGXgp[^Al͌^ϊsO̒lB
	 */
	private Map<String, Object> populatedBeanRawData;

	/**
	 * Cӂ̃NGXgXR[v̏i[MapB
	 */
	private Map<String, Object> attributes = new HashMap<String, Object>();

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * RXgN^B
	 * @param request HttpServletRequestIuWFNg
	 * @param response HttpServletResponseIuWFNg
	 * @param servletConfig ServletConfig ServletConfigIuWFNg
	 */
	private RequestContext(HttpServletRequest request, HttpServletResponse response, ServletConfig servletConfig) {
		if (threadLocalInstance.get() != null && logger.isWarnEnabled()) {
			logger.warn("FSCORE-LOGW002", Thread.currentThread().getName());
		}
		this.httpServletRequest = request;
		this.httpServletResponse = response;
		this.servletConfig = servletConfig;

		logger.info("FSCORE-LOGI008", Thread.currentThread().getName());
	}

	/**
	 * ReLXg𐶐ƓɁACX^XXbh[JɊi[܂B
	 * @param request HttpServletRequestIuWFNg
	 * @param response HttpServletResponseIuWFNg
	 * @param servletConfig ServletConfig ServletConfigIuWFNg
	 * @return CX^XB
	 */
	public static RequestContext create(HttpServletRequest request, HttpServletResponse response,
	        ServletConfig servletConfig) {

		RequestContext context = new RequestContext(request, response, servletConfig);
		threadLocalInstance.set(context);

		return context;
	}

	/**
	 * Xbh[JɕۑꂽCX^XԂ܂B
	 * {@link #create(HttpServletRequest, HttpServletResponse, ServletConfig)}sĂȂA
	 * {@link #clear()}sꂽłꍇ́AnullԂ܂B
	 * @return Xbh[JŕۑꂽReLXg̃CX^XB
	 */
	public static RequestContext get() {
		return threadLocalInstance.get();
	}

	/**
	 * Xbh[JɕۑꂽCX^XNA܂B
	 * ReLXg̃CX^XsvɂȂ_ŁAK̃\bhsKv܂B
	 */
	public static void clear() {
		RequestContext instance = threadLocalInstance.get();
		if (instance != null) {
			instance.removeFromThread();
		}
	}

	/**
	 * gXbh[JϐJ܂B
	 */
	private void removeFromThread() {
		threadLocalInstance.remove();
		logger.info("FSCORE-LOGI009", Thread.currentThread().getName());
	}

	/**
	 * HttpServletRequestIuWFNgԂ܂B
	 * @return HttpServletRequestIuWFNg
	 */
	public HttpServletRequest getHttpServletRequest() {
		return httpServletRequest;
	}

	/**
	 * HttpServletResponseIuWFNgԂ܂B
	 * @return HttpServletResponseIuWFNg
	 */
	public HttpServletResponse getHttpServletResponse() {
		return httpServletResponse;
	}

	/**
	 * ServletConfigIuWFNgԂ܂B
	 * @return ServletConfigIuWFNg
	 */
	public ServletConfig getServletConfig() {
		return servletConfig;
	}

	/**
	 * HttpServletRequestIuWFNgݒ肵܂B
	 * @param httpServletRequest HttpServletRequestIuWFNg
	 */
	public void setHttpServletRequest(HttpServletRequest httpServletRequest) {
		this.httpServletRequest = httpServletRequest;
	}

	/**
	 * HttpServletResponseIuWFNgݒ肵܂B
	 * @param httpServletResponse HttpServletResponseIuWFNg
	 */
	public void setHttpServletResponse(HttpServletResponse httpServletResponse) {
		this.httpServletResponse = httpServletResponse;
	}

	/**
	 * ServletConfigIuWFNgݒ肵܂B
	 * @param servletConfig ServletConfigIuWFNg
	 */
	public void setServletConfig(ServletConfig servletConfig) {
		this.servletConfig = servletConfig;
	}

	/**
	 * {@link com.small_it_office.flatserve.core.request.internal.RequestParameterReader}ɂēǂݍ񂾃NGXgp[^MapԂ܂B
	 * @return NGXgp[^MapB
	 */
	public Map<String, Object> getRequestParams() {
		return requestParams;
	}

	/**
	 * {@link com.small_it_office.flatserve.core.request.internal.RequestParameterReader}ɂēǂݍ񂾃NGXgp[^Mapݒ肵܂B
	 * @param requestParams NGXgp[^MapB
	 */
	public void setRequestParams(Map<String, Object> requestParams) {
		this.requestParams = requestParams;
	}

	/**
	 * HTTPNGXgǂݍ񂾁AHTTPT[rX\bḧɃ}bsOlԂ܂B
	 * @return rawParams HTTPT[rX\bḧɃ}bsOlB
	 */
	public Object[] getRawParams() {
		return rawParams == null ? null : rawParams.clone();
	}

	/**
	 * TTPNGXgǂݍ񂾁AHTTPT[rX\bḧɃ}bsOlݒ肵܂B
	 * @param rawParams HTTPT[rX\bḧɃ}bsOlB
	 */
	public void setRawParams(Object[] rawParams) {
		this.rawParams = rawParams == null ? null : rawParams.clone();
	}

	/**
	 * HTTPT[rX\bḧɃCWFNVlԂ܂B
	 * @return params HTTPT[rX\bḧɃCWFNVlB
	 */
	public Object[] getParams() {
		return params == null ? null : params.clone();
	}

	/**
	 * HTTPT[rX\bḧɃCWFNVlݒ肵܂B
	 * @param params HTTPT[rX\bḧɃCWFNVlB
	 */
	public void setParams(Object[] params) {
		this.params = params == null ? null : params.clone();
	}

	/**
	 * {@link com.small_it_office.flatserve.core.request.Populator}ɂăNGXgp[^i[ꂽBeanԂ܂B
	 * @return populatedBean
	 */
	public Object getPopulatedBean() {
		return populatedBean;
	}

	/**
	 * {@link com.small_it_office.flatserve.core.request.Populator}ɂăNGXgp[^i[ꂽBeanݒ肵܂B
	 * @param populatedBean populatedBean
	 */
	public void setPopulatedBean(Object populatedBean) {
		this.populatedBean = populatedBean;
	}

	/**
	 * {@link com.small_it_office.flatserve.core.request.Populator}ɂBean𐶐邽߂
	 * HTTPNGXgǂݍ񂾒lԂ܂B
	 * L[̓NGXgp[^Al͌^ϊsO̒lłB
	 * @return populatedBeanRawData Bean𐶐邽߂HTTPNGXgǂݍ񂾒lB
	 */
	public Map<String, Object> getPopulatedBeanRawData() {
		return populatedBeanRawData;
	}

	/**
	 * {@link com.small_it_office.flatserve.core.request.Populator}ɂBean𐶐邽߂
	 * HTTPNGXgǂݍ񂾒lݒ肵܂B
	 * L[̓NGXgp[^Al͌^ϊsO̒lłB
	 * @param populatedBeanRawData HTTPNGXgǂݍ񂾒lB
	 */
	public void setPopulatedBeanRawData(Map<String, Object> populatedBeanRawData) {
		this.populatedBeanRawData = populatedBeanRawData;
	}

	/**
	 * ReLXgɊi[ꂽNGXgXR[v̏擾܂B
	 * @param key 擾̃L[
	 * @return w肳ꂽL[Ŋi[ꂽ
	 */
	public Object getAttribute(String key) {
		return attributes.get(key);
	}

	/**
	 * FlatServevOCCӂ̏NGXgXR[vŊi[܂B
	 * HttpServletRequestɊi[ꍇƔׂāARequestContext̓AvP[V
	 * pȂAAvP[VFlatServe鋰ꂪȂƂbg܂B
	 * @param key i[̃L[
	 * @param value i[
	 */
	public void setAttribute(String key, Object value) {
		attributes.put(key, value);
	}
}
