package com.small_it_office.flatserve.core.request.bean.internal;

import java.lang.reflect.Field;
import java.util.Map;

import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.core.request.Header;
import com.small_it_office.flatserve.core.request.Param;
import com.small_it_office.flatserve.core.request.TrueValue;
import com.small_it_office.flatserve.core.request.internal.ParamNameConstants;
import com.small_it_office.flatserve.core.util.internal.StringUtil;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;

/**
 * RAW[{@link BeanParameterMapper}̎NXB
 * ̃NXł́AStringAString[]̃tB[hɑ΂Ċi[lǂݍ݂܂B
 */
public class BeanParameterMapperImpl extends BeanParameterMapper {

	/**
	 * BeanParameterReader̗D揇ʁB
	 */
	private static final int PRIORITY = 1024;

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * {@inheritDoc}
	 */
	public int getPriority() {
		return PRIORITY;
	}

	/**
	 * {@inheritDoc}
	 */
	public BeanMappedParameter process(Field field, BeanMappedParameter param) {
		logger.debug("FSCORE-LOGD041", this.getClass().getSimpleName(), field.getName());
		if (param.getParam() != null) {
			logger.debug("FSCORE-LOGD043", param.getParam());
			return getNestedReader().process(field, param);
		}
		if (!isPopulatableType(field)) {
			logger.debug("FSCORE-LOGD044", field.getType().getName());
			return getNestedReader().process(field, param);
		}

		Param paramAnnotation = field.getAnnotation(Param.class);
		Header headerAnnotation = field.getAnnotation(Header.class);
		Map<String, Object> requestParams = RequestContext.get().getRequestParams();
		if (headerAnnotation != null) {
			String headerName = headerAnnotation.value().toLowerCase();
			logger.debug("FSCORE-LOGD046", field.getName(), headerName);
			processRequestHeader(requestParams, headerName, param, field);
		} else {
			String paramName = paramAnnotation != null ? paramAnnotation.value() : field.getName();
			logger.debug("FSCORE-LOGD045", field.getName(), paramName);
			processRequestParam(requestParams, paramName, param, field);
		}
		getNestedReader().process(field, param);

		logger.debug("FSCORE-LOGD042", this.getClass().getSimpleName(), field.getName());
		return param;
	}

	/**
	 * tB[hɃCWFNV郊NGXgp[^擾܂B
	 * 
	 * @param requestParams {@link com.small_it_office.flatserve.core.request.internal.RequestParameterReader}Ŏ擾NGXgeB
	 * @param paramName p[^B
	 * @param param 擾li[IuWFNgB
	 * @param field Ώۂ̃tB[hB
	 */
	private void processRequestParam(Map<String, Object> requestParams, String paramName, BeanMappedParameter param,
	        Field field) {
		param.setParamName(paramName);
		Object objValue = requestParams.get(paramName);
		if (objValue == null) {
			logger.debug("FSCORE-LOGD047", paramName);
			if (field.getType().equals(boolean.class) || field.getType().equals(Boolean.class)) {
				param.setRawParam(null);
				param.setParam(false);
			}
		} else if (objValue instanceof String[]) {
			String[] values = (String[])objValue;
			if (field.getType().equals(String[].class)) {
				if (logger.isDebugEnabled()) {
					logger.debug("FSCORE-LOGD048", field.getName(), paramName, StringUtil.arrayToString(values));
				}
				param.setRawParam(values);
				param.setParam(values);
			} else if (field.getType().equals(String.class)) {
				logger.debug("FSCORE-LOGD048", field.getName(), paramName, values[0]);
				param.setRawParam(values[0]);
				param.setParam(values[0]);
			} else if (field.getType().equals(boolean.class) || field.getType().equals(Boolean.class)) {
				logger.debug("FSCORE-LOGD048", field.getName(), paramName, values[0]);
				param.setRawParam(values[0]);
				TrueValue trueValueAnno = field.getAnnotation(TrueValue.class);
				if (trueValueAnno == null) {
					param.setParam(true);
				} else {
					param.setParam(trueValueAnno.value().equals(values[0]));
				}
			}
		} else {
			logger.debug("FSCORE-LOGW003", paramName, objValue);
		}
	}

	/**
	 * tB[hɃCWFNV郊NGXgwb_擾܂B
	 * 
	 * @param requestParams {@link com.small_it_office.flatserve.core.request.internal.RequestParameterReader}Ŏ擾NGXgeB
	 * @param headerName wb_B
	 * @param param 擾li[IuWFNgB
	 * @param field Ώۂ̃tB[hB
	 */
	private void processRequestHeader(Map<String, Object> requestParams, String headerName, BeanMappedParameter param,
	        Field field) {
		//NGXgp[^ƃwb_ꍇAƂŃp[^㏑Ă܂A͎dlƂB
		param.setParamName(headerName);
		Object objHeader = requestParams.get(ParamNameConstants.REQUEST_HEADER_KEY_PREFIX + headerName);
		if (objHeader == null) {
			logger.debug("FSCORE-LOGD065", field.getName(), headerName);
		} else if (objHeader instanceof String) {
			String[] values = new String[]{(String)objHeader};
			if (field.getType() == String.class) {
				logger.debug("FSCORE-LOGD066", field.getName(), headerName, values[0]);
				param.setRawParam(values[0]);
				param.setParam(values[0]);
			}
		} else {
			logger.debug("FSCORE-LOGW004", headerName, objHeader);
		}
	}

	/**
	 * ΏۃtB[hAli[Ώۂ̌^ł邩ǂԂ܂B
	 * ftHg̎ł́AString܂String[]̏ꍇ̂trueԂ܂B
	 * TuNXŃI[o[ChđΏۂ̌^JX^}CYł܂B
	 * @param field ΏۃtB[h
	 * @return li[Ώۂ̌^łtrueB
	 */
	protected boolean isPopulatableType(Field field) {
		return field.getType() == String.class || field.getType() == String[].class || field.getType() == boolean.class
		        || field.getType() == Boolean.class;
	}
}
