package com.small_it_office.flatserve.aop.internal;

import java.lang.reflect.Method;

import javax.servlet.ServletConfig;

import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.plugin.internal.PluginPart;
import com.small_it_office.flatserve.core.service.internal.HttpServiceExecutor;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;

/**
 * AOPɑΉHttpServiceExecutor̎NXłB
 * ̃NX́AHTTPT[rX\bhɃAXyNgKp邽߂̎łB
 * HTTPT[rX\bh̎s͓ŕێHttpServiceExecutorIuWFNgɈڏ܂B
 */
public class AspectHttpServiceExecutor implements HttpServiceExecutor {

	/**
	 * ̃vOCi̗D揇ʁB
	 */
	private static final int PLUGIN_PRIORITY = 384;

	/**
	 * FlatServe̐ݒIuWFNgB
	 */
	private Config config;

	/**
	 * lXgHttpServiceExecutorB
	 */
	private HttpServiceExecutor serviceExecutor;

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * {@inheritDoc}
	 * HTTPT[rX\bh̎ss܂B
	 * AXyNg̐ݒɏ]ăC^[Zv^s܂B
	 */
	public Object execute(Method method, Object[] params, Object service) {
		AspectInvoker invoker = new AspectInvoker(config, serviceExecutor, method, params, service);
		logger.info("FSAOP-LOGI006", service.getClass().getName(), method.getName());
		Object result = invoker.invoke();
		logger.info("FSAOP-LOGI007", service.getClass().getName(), method.getName());
		return result;
	}

	/**
	 * {@inheritDoc}
	 * ̃NX͓ŃlXgHttpServiceExecutorێ邽߁AtrueԂ܂B
	 */
	public boolean nest() {
		return true;
	}

	/**
	 * {@inheritDoc}
	 */
	public void init(Config config, ServletConfig servletConfig) {
		this.config = config;
	}

	/**
	 * {@inheritDoc}
	 */
	public int priority() {
		return PLUGIN_PRIORITY;
	}

	/**
	 * {@inheritDoc}
	 */
	public void setNestedObject(PluginPart o) {
		serviceExecutor = (HttpServiceExecutor)o;
	}

}
