package com.small_it_office.flatserve.aop.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.aopalliance.intercept.MethodInterceptor;

import com.small_it_office.flatserve.aop.AspectConfig;
import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.service.HttpServiceException;
import com.small_it_office.flatserve.core.service.internal.HttpServiceExecutor;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import com.small_it_office.shared.meslog.message.Message;

/**
 * sΏۂ̃^[Qbg\bhɃAXyNgKpAC^[Zv^sNXłB
 */
public class AspectInvoker {

	/**
	 * HTTPT[rX\bh̎sڏ邽߂HttpServiceExecutorB
	 */
	private HttpServiceExecutor serviceExecutor;

	/**
	 * \bhɓKpC^[Zv^ԂŎIteratorB
	 */
	private Iterator<MethodInterceptor> interceptorIterator;

	/**
	 * HTTPT[rX\bh̃WCg|CgB
	 */
	private HttpServiceMethodInvocationImpl invocation;

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * RXgN^B
	 * @param config ݒIuWFNg
	 * @param serviceExecutor HTTPT[rX\bh̎sڏ邽߂HttpServiceExecutorIuWFNg
	 * @param method AXyNgKpĎs^[Qbg̃\bh
	 * @param params ^[Qbg\bh̃p[^
	 * @param service ^[Qbg\bhsIuWFNg
	 */
	public AspectInvoker(Config config, HttpServiceExecutor serviceExecutor, Method method, Object[] params,
	        Object service) {
		this.serviceExecutor = serviceExecutor;
		invocation = new HttpServiceMethodInvocationImpl(config, this, method, params, service);
		AspectConfig aspectConfig = config.getOptionalConfig(AspectConfig.class);

		interceptorIterator = assignInterceptors(aspectConfig, service.getClass(), method);
	}

	/**
	 * ݒIuWFNgɊi[ꂽAXyNg̐ݒ肩AKpׂɍvC^[Zv^Iʂ܂B
	 * @param aspectConfig AXyNg̐ݒ
	 * @param serviceClass sΏۂ̃NX
	 * @param serviceMethod sΏۂ̃\bh
	 * @return KpɍvC^[Zv^KpɕׂꂽIterator
	 */
	private Iterator<MethodInterceptor> assignInterceptors(AspectConfig aspectConfig, Class<?> serviceClass,
	        Method serviceMethod) {
		List<MethodInterceptor> list = new ArrayList<MethodInterceptor>();

		List<Aspect> aspectList = aspectConfig.getAspectList();
		for (Aspect aspect : aspectList) {
			boolean assignable = aspect.isAssignable(serviceClass, serviceMethod);
			if (logger.isDebugEnabled()) {
				if (assignable) {
					logger.debug("FSAOP-LOGD001", aspect.toString(), serviceClass.getName(), aspect.getInterceptor()
					        .getClass().getName());
				} else {
					logger.debug("FSAOP-LOGD002", aspect.toString(), serviceClass.getName(), aspect.getInterceptor()
					        .getClass().getName());
				}
			}
			if (assignable) {
				list.add(aspect.getInterceptor());
			}
		}

		return list.iterator();
	}

	/**
	 * C^[Zv^KpāA^[Qbg\bhs܂B
	 * @return ^[Qbg\bhԂ߂l
	 */
	public Object invoke() {
		try {
			return proceed();
		} catch (RuntimeException e) {
			throw e;
		} catch (Error e) {
			throw e;
		} catch (Throwable e) {
			//T[rX\bhŗOꍇRuntimeExceptioñTuNXł
			//HttpServiceExceptionɃbv̂ŁAɂ͗ȂB
			throw new HttpServiceException(Message.get("FSAOP-ERR002"), e);
		}
	}

	/**
	 * `FCꂽ̃C^[Zv^܂̓^[Qbg\bhɐn܂B
	 * @return ̃C^[Zv^܂̓^[QbgHTTPT[rX\bhԂ߂l
	 * @throws Throwable lXgC^[Zv^HTTPT[rX\bhOthrowꍇ
	 */
	public Object proceed() throws Throwable {
		if (interceptorIterator.hasNext()) {
			MethodInterceptor next = interceptorIterator.next();
			logger.info("FSAOP-LOGI001", next.getClass().getName());
			Object result = next.invoke(invocation);
			logger.info("FSAOP-LOGI002", next.getClass().getName());
			return result;
		}
		Method method = invocation.getMethod();
		Object[] params = invocation.getArguments();
		Object service = invocation.getThis();
		logger.info("FSAOP-LOGI003", service.getClass().getName(), method.getName());
		logger.debug("FSAOP-LOGD003", serviceExecutor.getClass().getName());
		Object result = serviceExecutor.execute(method, params, service);
		logger.info("FSAOP-LOGI004", service.getClass().getName(), method.getName());
		return result;
	}
}
