package com.small_it_office.flatserve.transition.internal;

import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

import javax.servlet.ServletConfig;

import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.plugin.internal.PluginPart;
import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.core.response.ForwardResponse;
import com.small_it_office.flatserve.core.service.internal.HttpServiceExecutor;
import com.small_it_office.flatserve.transition.TransitionConfig;
import com.small_it_office.flatserve.transition.TransitionException;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import com.small_it_office.shared.meslog.message.Message;

/**
 * ʑJڃ`FbNɑΉHttpServiceExecutor̎NXłB
 * sȉʑJڂ̏ꍇ́AΏۂHTTPT[rX\bhsA㏈̃tbNs܂B
 * ʑJڂȏꍇ́APɓŕێHttpServiceExecutorIuWFNgɈڏ܂B
 */
public class TransitionCheckHttpServiceExecutor implements HttpServiceExecutor {

	/**
	 * ̃vOCi̗D揇ʁB
	 */
	private static final int PLUGIN_PRIORITY = 64;

	/**
	 * lXgHttpServiceExecutorB
	 */
	private HttpServiceExecutor executor;

	/**
	 * sȉʑJڂꍇɃtH[h̃AhXB
	 */
	private String transitionErrorPath;

	/**
	 * ZbV^CAEgɂʑJڂs\ȏꍇɃtH[h̃AhXB
	 */
	private String sessionTimeoutPath;

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * {@inheritDoc}
	 * <p>
	 * ReLXg񂩂ʑJڂ̃`FbNʂ擾AłȂꍇɉʑJڃG[쐬܂B
	 * ʑJڂł΁APɃlXgHttpServiceExecutors܂B
	 * </p>
	 */
	public Object execute(Method method, Object[] params, Object service) {
		if (RequestContext.get().getAttribute(TransitionCheckConstants.CHECK_RESULT_STORE_KEY) == TransitionState.CORRECT) {
			return executor.execute(method, params, service);
		} else {
			logger.info("FSTRC-LOGI006");
			return executeTransitionError();
		}
	}

	/**
	 * sȉʑJڂꍇ̃X|X쐬܂B
	 * @return X|XIuWFNgB
	 */
	private ForwardResponse executeTransitionError() {

		RequestContext context = RequestContext.get();
		ForwardResponse result;
		if (context.getAttribute(TransitionCheckConstants.CHECK_RESULT_STORE_KEY) == TransitionState.WRONG) {
			if (transitionErrorPath == null) {
				throw new TransitionException(Message.get("FSTRC-ERR002"));
			}
			logger.info("FSTRC-LOGI004", transitionErrorPath);
			result = new ForwardResponse(transitionErrorPath);
		} else {
			if (sessionTimeoutPath == null) {
				throw new TransitionException(Message.get("FSTRC-ERR004"));
			}
			logger.info("FSTRC-LOGI005", sessionTimeoutPath);
			result = new ForwardResponse(sessionTimeoutPath);
		}

		result.setHeader("Cache-Control", "no-cache");
		result.setHeader("Pragma", "no-cache");
		result.setHeader("Expires", getHTTPDate());
		return result;
	}

	/**
	 * X|Xwb_ɐݒ肷邽߂̓t𐶐܂B
	 * @return HTTPtB
	 */
	private String getHTTPDate() {
		SimpleDateFormat formatter = new SimpleDateFormat("E, dd MMM yyyy hh:mm:ss zzz", Locale.US);
		formatter.setTimeZone(java.util.TimeZone.getTimeZone("GMT"));
		return formatter.format(new Date());
	}

	/**
	 * {@inheritDoc}
	 */
	public boolean nest() {
		return true;
	}

	/**
	 * {@inheritDoc}
	 */
	public void init(Config config, ServletConfig servletConfig) {
		TransitionConfig transitionConfig = config.getOptionalConfig(TransitionConfig.class);
		transitionErrorPath = transitionConfig.getTransitionErrorPath();
		sessionTimeoutPath = transitionConfig.getSessionTimeoutPath();
	}

	/**
	 * {@inheritDoc}
	 */
	public void setNestedObject(PluginPart o) {
		executor = (HttpServiceExecutor)o;
	}

	/**
	 * {@inheritDoc}
	 */
	public int priority() {
		return PLUGIN_PRIORITY;
	}

}
