package com.small_it_office.flatserve.transition.internal;

import javax.servlet.ServletConfig;

import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.plugin.internal.PluginImplementation;
import com.small_it_office.flatserve.core.request.internal.RequestParameterMapper;
import com.small_it_office.flatserve.core.request.internal.RequestParameterReader;
import com.small_it_office.flatserve.core.response.internal.ResponseSender;
import com.small_it_office.flatserve.core.service.internal.HttpServiceExecutor;
import com.small_it_office.flatserve.core.service.internal.HttpServiceFactory;
import com.small_it_office.flatserve.transition.TransitionConfig;

/**
 * Transition CheckvOC̎\NXłB
 */
public class TransitionCheckPluginImplementation implements PluginImplementation {

	/**
	 * {@inheritDoc}
	 */
	public HttpServiceExecutor getHttpServiceExecutor() {
		return new TransitionCheckHttpServiceExecutor();
	}

	/**
	 * {@inheritDoc}
	 */
	public HttpServiceFactory getHttpServiceFactory() {
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	public RequestParameterReader getRequestParameterReader() {
		return new TransitionCheckRequestParameterReader();
	}

	/**
	 * {@inheritDoc}
	 */
	public RequestParameterMapper getRequestParameterMapper() {
	    return null;
    }

	/**
	 * {@inheritDoc}
	 */
	public ResponseSender getResponseSender() {
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	public void init(Config config, ServletConfig servletConfig) {
		TransitionConfig transitionConfig = config.getOptionalConfig(TransitionConfig.class);
		if (transitionConfig == null) {
			transitionConfig = new TransitionConfig();
			config.addOptionalConfig(transitionConfig);
		}
	}
}
