package com.small_it_office.flatserve.transition.internal;

import java.lang.reflect.Method;

import javax.servlet.ServletConfig;

import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.plugin.internal.PluginPart;
import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.core.request.internal.ParameterHolder;
import com.small_it_office.flatserve.core.request.internal.RequestParameterMapper;

/**
 * ʑJڃ`FbNɑΉRequestParameterMapper̎NXłB
 * ʑJڃG[Mappeȑ𒆒fAȂΒPɎɃlXgꂽRequestParameterMapperĂяo܂B
 */
public class TransitionCheckRequestParameterMapper implements RequestParameterMapper {

	/**
	 * ̃vOCi̗D揇ʁB
	 */
	private static final int PLUGIN_PRIORITY = 128;

	/**
	 * ŕێRequestParameterReaderB
	 */
	private RequestParameterMapper nested;

	/**
	 * {@inheritDoc}
	 */
	public ParameterHolder process(Class<?> serviceClass, Method method, ParameterHolder params) {
		RequestContext context = RequestContext.get();
		if (context.getAttribute(TransitionCheckConstants.CHECK_RESULT_STORE_KEY) == TransitionState.CORRECT) {
			return nested.process(serviceClass, method, params);
		} else {
			return params;
		}
	}

	/**
	 * {@inheritDoc}
	 */
	public boolean nest() {
		return true;
	}

	/**
	 * {@inheritDoc}
	 */
	public void init(Config config, ServletConfig servletConfig) {
	}

	/**
	 * {@inheritDoc}
	 */
	public void setNestedObject(PluginPart o) {
		this.nested = (RequestParameterMapper)o;
	}

	/**
	 * {@inheritDoc}
	 */
	public int priority() {
		return PLUGIN_PRIORITY;
	}

}
