package com.small_it_office.flatserve.transition.internal;

import java.lang.reflect.Method;

import javax.servlet.http.HttpSession;

import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.transition.AllowedTokens;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;

/**
 * ʑJڂ̑Ó̃`FbNsNXłB
 * {@link #check(Class, Method)}\bh́Aw肳ꂽHTTPT[rX\bhɋLqꂽ
 * {@link AllowedTokens}Ame[VǂݎAŎw肳ꂽg[Nƕۑꂽg[Nr܂B
 * g[Nv邩Ag[NAme[VɂĎw肳ĂȂꍇ́AȉʑJڂƔf܂B
 */
public class TransitionChecker {

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * ʑJڂ̃`FbNs܂B
	 * @param serviceClass HTTPT[rXNX
	 * @param serviceMethod HTTPT[rX\bh
	 * @return `FbNʁB
	 */
	public TransitionState check(Class<?> serviceClass, Method serviceMethod) {
		AllowedTokens annotation = serviceMethod.getAnnotation(AllowedTokens.class);

		if (annotation == null) {
			logger.debug("FSTRC-LOGD001", serviceClass.getName(), serviceMethod.getName());
			return TransitionState.CORRECT;
		}

		HttpSession session = RequestContext.get().getHttpServletRequest().getSession(false);
		if (session == null) {
			logger.info("FSTRC-LOGI001");
			return TransitionState.TIMEOUT;
		}

		String currentToken = (String)session.getAttribute(TransitionCheckConstants.TOKEN_STORE_KEY);
		if (currentToken == null) {
			logger.info("FSTRC-LOGI002");
			return TransitionState.WRONG;
		}

		boolean result = compareToken(annotation, currentToken);

		if (!result) {
			logger.info("FSTRC-LOGI003", currentToken, serviceMethod.getName());
			return TransitionState.WRONG;
		}

		return TransitionState.CORRECT;
	}

	/**
	 * w肳ꂽg[NA{@link AllowedTokens}Ŏw肳ꂽɈv邩ǂmF܂B
	 * @param annotation HTTPT[rX\bhŎw肳ꂽ{@link AllowedTokens}Ame[V
	 * @param currentToken ۑꂽg[N
	 * @return ۑꂽg[NAme[VŎw肳ꂽɈvtrue
	 */
	private boolean compareToken(AllowedTokens annotation, String currentToken) {
		String[] allowedTokens = annotation.tokens();
		String[] allowedTokensStartsWith = annotation.tokensStartsWith();

		for (String allowedToken : allowedTokens) {
			if (currentToken.equals(allowedToken)) {
				logger.debug("FSTRC-LOGD002", currentToken);
				return true;
			}
		}

		for (String allowedTokenHead : allowedTokensStartsWith) {
			if (currentToken.startsWith(allowedTokenHead)) {
				logger.debug("FSTRC-LOGD003", currentToken, allowedTokenHead);
				return true;
			}
		}
		return false;
	}
}
