package com.small_it_office.flatserve.validator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

/**
 * of[VG[̃RNVێNXłB
 */
public class ValidationErrors implements Iterable<ValidationError>, Serializable {

	/**
	 * of[VG[̃XgB
	 */
	private List<ValidationError> errors = new ArrayList<ValidationError>();

	/**
	 * of[VG[̃Xg̏Ԃ肷邽߂́Ap[^̏\zB
	 */
	private String[] paramNameOrder;

	/**
	 * of[VG[ǉB
	 * @param error of[VG[
	 */
	public void add(ValidationError error) {
		errors.add(error);
	}

	/**
	 * of[VG[łێĂꍇtrueԂ܂B
	 * @return of[VG[݂trueAȂfalse
	 */
	public boolean hasError() {
		return !errors.isEmpty();
	}

	/**
	 * p[^̏zԂ܂B
	 * ̃of[VG[ꍇȀɏ]ĕێ܂B
	 * @return p[^̏zB
	 */
	public String[] getParamNameOrder() {
		return paramNameOrder == null ? null : paramNameOrder.clone();
	}

	/**
	 * p[^̏zݒ肵܂B
	 * ̃of[VG[ꍇȀɏ]ĕێ܂B
	 * @param methodNameOrder p[^̏zB
	 */
	public void setParamNameOrder(String[] methodNameOrder) {
		this.paramNameOrder = methodNameOrder == null ? null : methodNameOrder.clone();
	}

	/**
	 * of[VG[̃XgԂ܂B
	 * @return of[VG[̃Xg
	 */
	public List<ValidationError> getErrorList() {
		sort();
		return errors;
	}

	/**
	 * of[VG[IteratorŕԂ܂B
	 * {@inheritDoc}
	 */
	public Iterator<ValidationError> iterator() {
		sort();
		return errors.iterator();
	}

	/**
	 * ݕێĂof[VG[񂩂AŎɍv̂𒊏o܂B
	 * @param paramName of[VG[ƂȂp[^B
	 * @param category of[VG[̎ށB
	 * @return ̏ɍvof[VG[̃XgB
	 */
	public List<ValidationError> findError(String paramName, ValidationErrorCategory category) {
		sort();
		List<ValidationError> found = new ArrayList<ValidationError>();
		for (ValidationError error : errors) {
			if (paramName.equals(error.getParameterName()) && category == error.getCategory()) {
				found.add(error);
			}
		}
		return found;
	}

	/**
	 * ݕێĂof[VG[񂩂AŎɍv̂𒊏o܂B
	 * @param paramName of[VG[ƂȂp[^B
	 * @param category of[VG[̎ށB
	 * @param arrayIndex z̃CfbNXBzłȂꍇ0w肵܂B
	 * @return ̏ɍvof[VG[B
	 */
	public ValidationError findError(String paramName, ValidationErrorCategory category, int arrayIndex) {
		sort();
		for (ValidationError error : errors) {
			if (paramName.equals(error.getParameterName()) && category == error.getCategory()
			        && arrayIndex == error.getArrayIndex()) {
				return error;
			}
		}
		return null;
	}

	/**
	 * ̃IuWFNgێ邷ׂẴof[VG[bZ[WHTMLŕԂ܂B
	 * ׂẴbZ[W&lt;br /&gt;ŘA܂B
	 * @return G[bZ[WHTML
	 */
	public String getHtml() {
		sort();
		String html = "";
		for (ValidationError error : this) {
			html += error.getMessage();
			html += "<br />";
		}
		return html;
	}

	/**
	 * ̃IuWFNgێ邷ׂẴof[VG[bZ[W𕶎ŕԂ܂B
	 * ׂẴbZ[WsŘA܂B
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		sort();
		String str = "";
		for (ValidationError error : this) {
			str += error.getMessage();
			str += System.getProperty("line.separator");
		}
		return str;
	}

	/**
	 * of[VG[̃Xg\[g܂B
	 */
	private void sort() {
		if (paramNameOrder == null) {
			return;
		}
		Comparator<ValidationError> comparator = new ValidationErrorComparator();
		Collections.sort(errors, comparator);
	}

	/**
	 * of[VG[̃Xg\[g邽߂ComparatorB
	 */
	private class ValidationErrorComparator implements Comparator<ValidationError>, Serializable {

		/**
		 * {@inheritDoc}
		 */
		public int compare(ValidationError o1, ValidationError o2) {
			String paramName1 = o1.getParameterName();
			String paramName2 = o2.getParameterName();

			if (paramName1 == null && paramName2 == null) {
				return 0;
			} else if (paramName1 == null) {
				return 1;
			} else if (paramName2 == null) {
				return -1;
			}

			int index1 = Integer.MAX_VALUE;
			int index2 = Integer.MAX_VALUE;

			for (int i = 0; i < paramNameOrder.length; i++) {
				if (paramName1.equals(paramNameOrder[i])) {
					index1 = i;
				}
				if (paramName2.equals(paramNameOrder[i])) {
					index2 = i;
				}
			}

			if (index1 == index2) {
				return o1.getArrayIndex() - o2.getArrayIndex();
			}

			return index1 - index2;
		}
	}
}
