package com.small_it_office.flatserve.validator.converter.internal;

import java.lang.annotation.Annotation;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import com.small_it_office.flatserve.core.util.internal.AnnotationUtil;
import com.small_it_office.flatserve.validator.MessageResource;
import com.small_it_office.flatserve.validator.internal.MessageResourceHolder;
import com.small_it_office.flatserve.validator.internal.ValidatorConstants;
import com.small_it_office.flatserve.validator.rule.DateFormat;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;

/**
 * java.util.Date^ɕϊRo[^B
 * tH[}bgɏ]t^ɕϊ܂BtH[}bg͔CӂɎwł܂B
 * w肵ȂꍇAftHgł"yyyy-MM-dd"Ƃ܂B
 */
public class DateTypeConverter extends AbstractTypeConverter {

	/**
	 * ftHg̓ttH[}bgB
	 */
	private static final String DEFAULT_FORMAT = "yyyy-MM-dd";

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected Date convert(String stringValue, Annotation[] annotations) {
		SimpleDateFormat format = createDateFormat(annotations);
		logger.debug("FSVLD-LOGD037", stringValue, format.toPattern());

		ParsePosition position = new ParsePosition(0);

		Date date = format.parse(stringValue, position);

		if (date == null) {
			return null;
		}
		if (position.getIndex() < stringValue.length()) {
			return null;
		}
		return date;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String getErrorMessage(String value, Annotation[] annotations) {
		DateFormat dateFormatAnnotation = AnnotationUtil.findAnnotation(annotations, DateFormat.class);

		String format = dateFormatAnnotation == null ? DEFAULT_FORMAT : dateFormatAnnotation.value();

		MessageResource messageResource = MessageResourceHolder.getInstance().get();
		Map<String, Object> map = new HashMap<String, Object>();
		map.put(ValidatorConstants.MESSAGE_PLACEHOLDER_ERRORVALUE, value);
		map.put(ValidatorConstants.MESSAGE_PLACEHOLDER_DATEFORMAT, format);
		return messageResource.getMessage("{message.error.type.date}", map);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected Object getNullValue() {
		return null;
	}

	/**
	 * ttH[}bg̃IuWFNg𐶐܂B
	 * Ame[VŎw肳Ă΂̃p^[Aw肳ĂȂ΃ftHgKp܂B
	 * @param annotations ܂JavaBeañtB[hɎw肳ꂽof[V[Ame[VB
	 * @return ttH[}bgB
	 */
	private SimpleDateFormat createDateFormat(Annotation[] annotations) {
		DateFormat dateFormatAnnotation = AnnotationUtil.findAnnotation(annotations, DateFormat.class);

		String formatString = dateFormatAnnotation == null ? DEFAULT_FORMAT : dateFormatAnnotation.value();

		SimpleDateFormat format = new SimpleDateFormat(formatString);
		format.setLenient(false);

		return format;
	}
}
