package com.small_it_office.flatserve.validator.converter.internal;

import java.lang.annotation.Annotation;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.Map;

import com.small_it_office.flatserve.core.util.internal.AnnotationUtil;
import com.small_it_office.flatserve.validator.MessageResource;
import com.small_it_office.flatserve.validator.internal.MessageResourceHolder;
import com.small_it_office.flatserve.validator.internal.ValidatorConstants;
import com.small_it_office.flatserve.validator.rule.NumberFormat;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;

/**
 * Long^ɕϊRo[^B
 */
public class LongTypeConverter extends AbstractTypeConverter {

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected Long convert(String stringValue, Annotation[] annotations) {
		NumberFormat numberFormatAnnotation = AnnotationUtil.findAnnotation(annotations, NumberFormat.class);
		if (numberFormatAnnotation == null) {
			try {
				return Long.valueOf(stringValue);
			} catch (NumberFormatException e) {
				return null;
			}
		} else {
			logger.debug("FSVLD-LOGD005", stringValue, numberFormatAnnotation.value());
			DecimalFormat df = new DecimalFormat(numberFormatAnnotation.value());
			ParsePosition position = new ParsePosition(0);
			Number number = df.parse(stringValue, position);
			if (number == null) {
				return null;
			}
			if (position.getIndex() < stringValue.length()) {
				return null;
			}

			if (!(number instanceof Long)) {
				return null;
			}
			return number.longValue();
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
    protected String getErrorMessage(String value, Annotation[] annotations) {
		NumberFormat numberFormatAnnotation = AnnotationUtil.findAnnotation(annotations, NumberFormat.class);
		String format = numberFormatAnnotation == null ? null : numberFormatAnnotation.value();

		MessageResource messageResource = MessageResourceHolder.getInstance().get();
		Map<String, Object> map = new HashMap<String, Object>();
		map.put(ValidatorConstants.MESSAGE_PLACEHOLDER_ERRORVALUE, value);
		map.put(ValidatorConstants.MESSAGE_PLACEHOLDER_NUMBERFORMAT, format);
    	return messageResource.getMessage("{message.error.type.long}", map);
    }

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected Long getNullValue() {
		return null;
	}

}
