package com.small_it_office.flatserve.validator.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Date;

import com.small_it_office.flatserve.core.request.Header;
import com.small_it_office.flatserve.core.request.Param;
import com.small_it_office.flatserve.core.request.bean.internal.BeanMappedParameter;
import com.small_it_office.flatserve.core.request.bean.internal.BeanParameterMapper;
import com.small_it_office.flatserve.core.util.internal.AnnotationUtil;
import com.small_it_office.flatserve.validator.mapping.internal.ValidationParameterMapping;
import com.small_it_office.flatserve.validator.mapping.internal.ValidationRequestParameterMappingFactory;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;

/**
 * HTTPNGXgJavaBeanւ̕ϊs߂ɒlǂݍރNXB
 * l^java.util.Date^ȂǂɑΉĂ܂B
 * ^ϊłȂꍇɂ̓of[VG[𐶐܂B
 */
public class ValidatorBeanParameterMapper extends BeanParameterMapper {

	/**
	 * BeanParameterMapper̗D揇ʁB
	 */
	private static final int PRIORITY = 512;

	/**
	 * NGXgp[^tB[hɃ}bsOIuWFNg̃t@NgB
	 */
	private ValidationRequestParameterMappingFactory mappingFactory = new ValidationRequestParameterMappingFactory();

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getPriority() {
		return PRIORITY;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public BeanMappedParameter process(Field field, BeanMappedParameter param) {
		logger.debug("FSVLD-LOGD030", this.getClass().getSimpleName(), field.getName());
		Annotation[] annotations = field.getAnnotations();
		if (param.getParam() != null) {
			logger.debug("FSVLD-LOGD038", param.getParam());
		} else if (!isPopulatableType(field)) {
			logger.debug("FSVLD-LOGD039", field.getType().getName());
		} else if (AnnotationUtil.findAnnotation(annotations, Header.class) != null) {
			logger.debug("FSVLD-LOGD029", field.getName());
		} else {
			doProcess(field, param, annotations);
		}

		param = getNestedReader().process(field, param);

		logger.debug("FSVLD-LOGD031", this.getClass().getSimpleName(), field.getName());

		return param;
	}

	/**
	 * ^ϊ̃CłB
	 * @param field ϊ̃tB[hB
	 * @param param HTTPNGXgǂݍ񂾒li[IuWFNgB
	 * @param annotations tB[hɕt^ꂽAme[VB
	 */
	private void doProcess(Field field, BeanMappedParameter param, Annotation[] annotations) {
		String paramName;
		Param paramAnnotation = AnnotationUtil.findAnnotation(annotations, Param.class);
		if (paramAnnotation == null) {
			paramName = field.getName();
		} else {
			paramName = paramAnnotation.value();
		}

		logger.debug("FSVLD-LOGD040", paramName);

		ValidationParameterMapping paramMapping = mappingFactory.getMapping(field.getType());
		Object mappedRawParam = paramMapping.mapRawParameter(annotations, paramName, param.getRawParam());
		Object mappedParam = paramMapping.mapParameter(annotations, paramName, param.getParam());

		param.setParam(mappedParam);
		param.setRawParam(mappedRawParam);
		param.setParamName(paramName);
	}

	/**
	 * ̃NXŌ^ϊƂăT|[g^ł邩ǂԂ܂B
	 * @param field ϊ̃tB[hB
	 * @return tB[ȟ^T|[gΏۂłtrueB
	 */
	private boolean isPopulatableType(Field field) {
		Class<?> type = field.getType();
		if (type.isArray()) {
			type = type.getComponentType();
		}
		boolean result = false;
		result |= type == int.class;
		result |= type == long.class;
		result |= type == float.class;
		result |= type == double.class;
		result |= type == Integer.class;
		result |= type == Long.class;
		result |= type == Float.class;
		result |= type == Double.class;
		result |= type == BigDecimal.class;
		result |= type == Date.class;
		return result;
	}
}
