package com.small_it_office.flatserve.validator.internal;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.small_it_office.flatserve.core.UnexpectedException;
import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.plugin.internal.PluginPart;
import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.core.service.internal.HttpServiceExecutor;
import com.small_it_office.flatserve.validator.MessageResource;
import com.small_it_office.flatserve.validator.OnValidationError;
import com.small_it_office.flatserve.validator.ValidationErrorResponse;
import com.small_it_office.flatserve.validator.ValidationErrorResponseException;
import com.small_it_office.flatserve.validator.ValidationErrors;
import com.small_it_office.flatserve.validator.ValidatorConfig;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import com.small_it_office.shared.meslog.message.Message;

/**
 *of[VɑΉHttpServiceExecutor̎NXłB
 * <p>
 * ̃NXł́Aof[V̌ʁAG[Ȃꍇ͒ʏʂHTTPT[rX\bhs܂B
 * </p>
 * <p>
 * of[VG[݂ꍇ́AHTTPT[rX\bh̎s͍s킸A
 * of[VG[\bhw肳Ă΁A̎s݂܂B
 * w肳ĂȂꍇAof[VG[NXɂG[s܂B
 * </p>
 */
public class ValidatorHttpServiceExecutor implements HttpServiceExecutor {

	/**
	 * ̃vOCi̗D揇ʁB
	 */
	private static final int PLUGIN_PRIORITY = 256;

	/**
	 * of[VG[NX̃CX^XB
	 */
	private ValidationErrorResponse defaultErrorResponse;

	/**
	 * lXgHttpServiceExecutorB
	 */
	private HttpServiceExecutor executor;

	/**
	 * of[VG[bZ[W̃bZ[W\[XB
	 */
	private MessageResource messageResource;

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * RXgN^B
	 * @param messageResource G[bZ[W̃bZ[W\[XB
	 */
	public ValidatorHttpServiceExecutor(MessageResource messageResource) {
		this.messageResource = messageResource;
	}

	/**
	 * of[VG[Ȃꍇ͒ʏʂHTTPT[rX\bhs܂B
	 * of[VG[݂ꍇ́Aof[VG[\bh܂
	 * of[VG[NX𗘗pāAG[쐬܂B
	 * {@inheritDoc}
	 */
	public Object execute(Method method, Object[] params, Object service) {
		logger.debug("FSVLD-LOGD032");
		RequestContext context = RequestContext.get();
		ValidationErrors errors = (ValidationErrors)context.getAttribute(ValidatorConstants.ERRORS_STORE_KEY);
		if (!errors.hasError()) {
			MessageResourceHolder.getInstance().set(messageResource);
			try {
				Object result = executor.execute(method, params, service);
				logger.debug("FSVLD-LOGD033");
				return result;
			} catch (PopulatorValidationException e) {
				logger.debug("FSVLD-LOGD034");
			} finally {
				MessageResourceHolder.getInstance().clear();
			}
		} else {
			logger.debug("FSVLD-LOGD035");
		}

		OnValidationError annotation = method.getAnnotation(OnValidationError.class);
		if (annotation == null) {
			logger.info("FSVLD-LOGI001", defaultErrorResponse.getClass().getName());

			Object result;
			try {
				result = defaultErrorResponse.responseValidationError(errors, context.getHttpServletRequest(), context
				        .getHttpServletResponse(), context.getServletConfig());
			} catch (IOException e) {
				throw new ValidationErrorResponseException(Message.get("FSVLD-ERR008"), e);
			}

			logger.info("FSVLD-LOGI002", defaultErrorResponse.getClass().getName());

			logger.debug("FSVLD-LOGD033");
			return result;
		}

		String methodName = annotation.value();

		Method errorMethod = reflectErrorResponseMethod(service, methodName);
		Object[] parameters = createErrorResponseMethodParams(errorMethod);
		Object result = executeErrorResponseMethod(service, errorMethod, parameters);

		logger.debug("FSVLD-LOGD033");
		return result;
	}

	/**
	 * of[VG[\bhAtNVŎ擾܂B
	 * @param service of[VG[\bhsHTTPT[rXIuWFNg
	 * @param methodName of[VG[\bh
	 * @return of[VG[\bh
	 */
	private Method reflectErrorResponseMethod(Object service, String methodName) {
		Class<?> currentClass = service.getClass();
		Method errorMethod = null;
		while (currentClass != Object.class && errorMethod == null) {
			Method[] declaredMethods = currentClass.getDeclaredMethods();

			for (Method declaredMethod : declaredMethods) {
				if (Modifier.isPublic(declaredMethod.getModifiers()) && methodName.equals(declaredMethod.getName())) {
					errorMethod = declaredMethod;
					break;
				}
			}
			currentClass = currentClass.getSuperclass();
		}

		if (errorMethod == null) {
			throw new ValidationErrorResponseException(Message.get("FSVLD-ERR003", service.getClass().getName(),
			        methodName));
		}

		return errorMethod;

	}

	/**
	 * of[VG[\bhɓn𐶐܂B
	 * @param errorMethod of[VG[\bh
	 * @return of[V\bhɓn̔z
	 */
	private Object[] createErrorResponseMethodParams(Method errorMethod) {
		Class<?>[] paramClasses = errorMethod.getParameterTypes();
		Object[] parameters = new Object[paramClasses.length];

		RequestContext context = RequestContext.get();

		for (int i = 0; i < paramClasses.length; i++) {
			if (logger.isDebugEnabled()) {
				logger.debug("FSVLD-LOGD001", errorMethod.getName(), i + 1, paramClasses[i].getName());
			}

			if (paramClasses[i] == ValidationErrors.class) {
				parameters[i] = context.getAttribute(ValidatorConstants.ERRORS_STORE_KEY);
			} else if (paramClasses[i] == Object[].class) {
				if (context.getPopulatedBeanRawData() == null) {
					parameters[i] = context.getRawParams();
				} else {
					parameters[i] = new Object[] {context.getPopulatedBeanRawData()};
				}
			} else if (paramClasses[i] == HttpServletRequest.class) {
				parameters[i] = context.getHttpServletRequest();
			} else if (paramClasses[i] == HttpServletResponse.class) {
				parameters[i] = context.getHttpServletResponse();
			} else if (paramClasses[i] == ServletConfig.class) {
				parameters[i] = context.getServletConfig();
			} else if (paramClasses[i].isPrimitive()) {
				throw new ValidationErrorResponseException(Message.get("FSVLD-ERR004", errorMethod.getDeclaringClass()
				        .getName(), errorMethod.getName()));
			} else {
				if (logger.isWarnEnabled()) {
					logger.warn("FSVLD-LOGW001", errorMethod.getDeclaringClass().getName(), errorMethod.getName(),
					        paramClasses[i].getName());
				}
			}
		}
		return parameters;
	}

	/**
	 * of[VG[\bhs܂B
	 * @param service  of[VG[\bhsHTTPT[rXIuWFNg
	 * @param errorMethod of[VG[\bh
	 * @param parameters \bḧ
	 * @return \IuWFNg
	 */
	private Object executeErrorResponseMethod(Object service, Method errorMethod, Object[] parameters) {
		logger.info("FSVLD-LOGI003", service.getClass().getName(), errorMethod.getName());
		Object result;
		try {
			result = errorMethod.invoke(service, parameters);
		} catch (InvocationTargetException e) {
			Throwable cause = e.getTargetException();
			if (cause instanceof RuntimeException) {
				throw (RuntimeException)cause;
			}
			if (cause instanceof Error) {
				throw (Error)cause;
			}
			throw new ValidationErrorResponseException(Message.get("FSVLD-ERR005", service.getClass().getName(),
			        errorMethod.getName()), cause);
		} catch (IllegalAccessException e) {
			throw new UnexpectedException(e);
		}
		logger.info("FSVLD-LOGI004", service.getClass().getName(), errorMethod.getName());
		return result;
	}

	/**
	 * {@inheritDoc}
	 */
	public boolean nest() {
		return true;
	}

	/**
	 * {@inheritDoc}
	 */
	public void init(Config config, ServletConfig servletConfig) {
		ValidatorConfig validatorConfig = config.getOptionalConfig(ValidatorConfig.class);
		defaultErrorResponse = validatorConfig.getDefaultErrorResponse();
		logger.debug("FSVLD-LOGD002", defaultErrorResponse.getClass().getName());
	}

	/**
	 * {@inheritDoc}
	 */
	public void setNestedObject(PluginPart o) {
		this.executor = (HttpServiceExecutor)o;
	}

	/**
	 * {@inheritDoc}
	 */
	public int priority() {
		return PLUGIN_PRIORITY;
	}

	/**
	 * P̃eXgp\bhB
	 * @return ftHg̃of[VG[sIuWFNg
	 */
	ValidationErrorResponse getDefaultErrorResponse() {
		return defaultErrorResponse;
	}

	/**
	 * P̃eXgp\bhB
	 * @return lXgꂽHttpServiceExecutorIuWFNg
	 */
	HttpServiceExecutor getNestedObject() {
		return executor;
	}
}
