package com.small_it_office.flatserve.validator.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;

import javax.servlet.ServletConfig;

import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.plugin.internal.PluginPart;
import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.core.request.Param;
import com.small_it_office.flatserve.core.request.internal.ParameterHolder;
import com.small_it_office.flatserve.core.request.internal.RequestParameterMapper;
import com.small_it_office.flatserve.core.util.internal.AnnotationUtil;
import com.small_it_office.flatserve.validator.MessageResource;
import com.small_it_office.flatserve.validator.ValidationErrors;
import com.small_it_office.flatserve.validator.internal.util.ErrorUtil;
import com.small_it_office.flatserve.validator.mapping.internal.ValidationParameterMapping;
import com.small_it_office.flatserve.validator.mapping.internal.ValidationRequestParameterMappingFactory;
import com.small_it_office.flatserve.validator.rule.ItemName;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;


/**
 * of[VɑΉRequestParameterMapper̎NXłB
 * NGXgp[^Al^ȂStringȊÖɃ}bsO\łB
 */
public class ValidatorRequestParameterMapper implements RequestParameterMapper {

	/**
	 * ̃vOCi̗D揇ʁB
	 */
	private static final int PLUGIN_PRIORITY = 768;

	/**
	 * lXgRequestParameterMapperIuWFNgB
	 */
	private RequestParameterMapper nested;

	/**
	 * NGXgp[^Ƀ}bsOIuWFNg̃t@NgB
	 */
	private ValidationRequestParameterMappingFactory mappingFactory = new ValidationRequestParameterMappingFactory();

	/**
	 * of[VG[bZ[W̃bZ[W\[XB
	 */
	private MessageResource messageResource;

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * RXgN^B
	 * @param messageResource of[VG[bZ[W̃bZ[W\[XB
	 */
	public ValidatorRequestParameterMapper(MessageResource messageResource) {
		this.messageResource = messageResource;
	}

	/**
	 * {@inheritDoc}
	 */
	public ParameterHolder process(Class<?> serviceClass, Method method, ParameterHolder params) {
		logger.debug("FSVLD-LOGD011");
		MessageResourceHolder.getInstance().set(messageResource);

		try {
			ValidationErrors errors = new ValidationErrors();
			RequestContext.get().setAttribute(ValidatorConstants.ERRORS_STORE_KEY, errors);

			createParamsWithTypeValidation(method, params);

			params = nested.process(serviceClass, method, params);

			validateParamsByRules(method, params);

			logger.debug("FSVLD-LOGD012");
			return params;
		} finally {
			MessageResourceHolder.getInstance().clear();
		}
	}

	/**
	 * HTTPNGXgǂݍ݁A\bḧ𐶐܂B
	 * NGXgp[^̌^ɕϊłȂꍇ́Aof[VG[𐶐܂B
	 * @param method \bhB
	 * @param params i[IuWFNgBɐς݂̈͊i[ꂽԂœn܂B
	 */
	private void createParamsWithTypeValidation(Method method, ParameterHolder params) {
		Class<?>[] paramTypes = method.getParameterTypes();
		String[] paramNameOrder = new String[paramTypes.length];
		Annotation[][] paramAnnotations = method.getParameterAnnotations();
		for (int i = 0; i < params.length(); i++) {
			Class<?> type = paramTypes[i];
			Annotation[] annotations = paramAnnotations[i];

			//ǂݍݑΏۂ̓NGXgp[^̂݁Bwb_Strinĝ݂Ȃ̂ŁAValidatorvOCł͊֒mȂB
			Param paramAnnotation = AnnotationUtil.findAnnotation(annotations, Param.class);
			String paramName = paramAnnotation == null ? null : paramAnnotation.value();
			paramNameOrder[i] = paramName;

			logger.debug("FSVLD-LOGD013", method.getName(), i + 1, paramName);

			ValidationParameterMapping paramMapping = mappingFactory.getMapping(type);
			Object mappedRawParam = paramMapping.mapRawParameter(annotations, paramName, params.getRawParam(i));
			Object mappedParam = paramMapping.mapParameter(annotations, paramName, params.getParam(i));

			logger.debug("FSVLD-LOGD014", method.getName(), i + 1);

			params.setRawParam(i, mappedRawParam);
			params.setParam(i, mappedParam);
		}
		ValidationErrors errors = ErrorUtil.getValidationErrors();
		errors.setParamNameOrder(paramNameOrder);
	}


	/**
	 * ̃[ɂof[Vs܂B
	 * @param method \bhB
	 * @param params ꂽB
	 */
	private void validateParamsByRules(Method method, ParameterHolder params) {
		Annotation[][] paramAnnotations = method.getParameterAnnotations();
		for (int i = 0; i < params.length(); i++) {
			Annotation[] annotations = paramAnnotations[i];
			Param paramAnnotation = AnnotationUtil.findAnnotation(annotations, Param.class);
			//vOC̊glAof[VΏۂ̈́A@Paramt̂Ƃ͌ȂdlƂB
			//̂ƂA@ParamȊOp[^擾@͂Ȃ̂ŁAKvꍇɑΉKvB
			String paramName = paramAnnotation == null ? "" : paramAnnotation.value();

			ValidationRuleList ruleList = ValidationRuleList.assignRules(annotations);

			Object param = params.getParam(i);
			Object rawParam = params.getRawParam(i);

			logger.debug("FSVLD-LOGD017", method.getName(), i + 1, paramName);

			ItemName itemNameAnnotation = AnnotationUtil.findAnnotation(annotations, ItemName.class);
			String itemName = itemNameAnnotation == null ? null : itemNameAnnotation.value();
			ruleList.validateRules(paramName, rawParam, param, itemName);

			if (param != null && !param.getClass().isPrimitive() && !param.getClass().getName().startsWith("java")
			        && rawParam instanceof Map) {
				@SuppressWarnings("unchecked")
				Map<String, Object> beanRawParam = (Map<String, Object>)rawParam;
				BeanValidator.getInstance().validate(param, beanRawParam);
			}

			logger.debug("FSVLD-LOGD024", method.getName(), i + 1, paramName);
		}
	}

	/**
	 * {@inheritDoc}
	 */
	public void init(Config config, ServletConfig servletConfig) {
	}

	/**
	 * {@inheritDoc}
	 */
	public int priority() {
		return PLUGIN_PRIORITY;
	}

	/**
	 * {@inheritDoc}
	 */
	public boolean nest() {
		return true;
	}

	/**
	 * {@inheritDoc}
	 */
	public void setNestedObject(PluginPart o) {
		nested = (RequestParameterMapper)o;
	}

}
