package com.small_it_office.flatserve.validator.mapping.internal;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;

/**
 * ValidatorvOCHTTPT[rX\bḧƃNGXgp[^̃}bsOsNX̃t@NgłB
 * HTTPT[rX\bḧ̌^ɉ}bsONX̃CX^XԂ܂B
 */
public class ValidationRequestParameterMappingFactory {

	/**
	 * ^RequestParameterMapping̑ΉێMapB
	 */
	private Map<Class<?>, ValidationParameterMapping> typeMapping = new HashMap<Class<?>, ValidationParameterMapping>();

	/**
	 * T|[gΏۂłȂ^̏ꍇɓKp}bsOIuWFNgB
	 */
	private ValidationParameterMapping unsupportedMapping = new UnsupportedParameterMapping();
	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * RXgN^B
	 */
	public ValidationRequestParameterMappingFactory() {
		typeMapping.put(Integer.class, new ValidationParameterMappingImpl(Integer.class));
		typeMapping.put(Integer[].class, new ValidationParameterMappingImpl(Integer[].class));
		typeMapping.put(int.class, new ValidationParameterMappingImpl(int.class));
		typeMapping.put(int[].class, new ValidationParameterMappingImpl(int[].class));
		typeMapping.put(Long.class, new ValidationParameterMappingImpl(Long.class));
		typeMapping.put(Long[].class, new ValidationParameterMappingImpl(Long[].class));
		typeMapping.put(long.class, new ValidationParameterMappingImpl(long.class));
		typeMapping.put(long[].class, new ValidationParameterMappingImpl(long[].class));
		typeMapping.put(Float.class, new ValidationParameterMappingImpl(Float.class));
		typeMapping.put(Float[].class, new ValidationParameterMappingImpl(Float[].class));
		typeMapping.put(float.class, new ValidationParameterMappingImpl(float.class));
		typeMapping.put(float[].class, new ValidationParameterMappingImpl(float[].class));
		typeMapping.put(Double.class, new ValidationParameterMappingImpl(Double.class));
		typeMapping.put(Double[].class, new ValidationParameterMappingImpl(Double[].class));
		typeMapping.put(double.class, new ValidationParameterMappingImpl(double.class));
		typeMapping.put(double[].class, new ValidationParameterMappingImpl(double[].class));
		typeMapping.put(Date.class, new ValidationParameterMappingImpl(Date.class));
		typeMapping.put(Date[].class, new ValidationParameterMappingImpl(Date[].class));
		typeMapping.put(BigDecimal.class, new ValidationParameterMappingImpl(BigDecimal.class));
		typeMapping.put(BigDecimal[].class, new ValidationParameterMappingImpl(BigDecimal[].class));
	}

	/**
	 * w肳ꂽ^ɑΉ}bsOIuWFNgԂ܂B
	 * @param type }bsOΏۂ̃tB[h܂͈̌^B
	 * @return }bsOIuWFNgB
	 */
	public ValidationParameterMapping getMapping(Class<?> type) {
		ValidationParameterMapping mapping = typeMapping.get(type);
		if (mapping == null) {
			logger.debug("FSVLD-LOGD009", type.getName());
			return unsupportedMapping;
		}
		logger.debug("FSVLD-LOGD004", type.getName(), mapping.getClass().getName());
		return mapping;
	}

}
